/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;

public class MigrationEntityIdentifierMapper {
    private MigrationEntityIdentifierMapper() {
        throw new UnsupportedOperationException("MigrationEntityIdentifierMapper is a utility class and shouldn't be instantiated");
    }

    public static String getEntityIdentifier(Object entity) {
        if (entity == null) {
            return "job";
        }
        if (entity instanceof PullRequest) {
            return "pr: " + MigrationEntityIdentifierMapper.getEntityIdentifier((PullRequest)entity);
        }
        if (entity instanceof Repository) {
            return "repo: " + MigrationEntityIdentifierMapper.getEntityIdentifier((Repository)entity);
        }
        if (entity instanceof Project) {
            return "project: " + MigrationEntityIdentifierMapper.getEntityIdentifier((Project)entity);
        }
        if (entity instanceof String) {
            return (String)entity;
        }
        return "other: " + String.valueOf(entity);
    }

    public static String getPullRequestIdentifier(Repository repository, long scopedId) {
        return MigrationEntityIdentifierMapper.getEntityIdentifier(repository) + "#" + scopedId;
    }

    private static String getEntityIdentifier(Project project) {
        return project.getKey() + "[" + project.getId() + "]";
    }

    private static String getEntityIdentifier(PullRequest pullRequest) {
        return MigrationEntityIdentifierMapper.getEntityIdentifier(pullRequest.getToRef().getRepository()) + "#" + pullRequest.getId();
    }

    private static String getEntityIdentifier(Repository repository) {
        return repository.getProject().getKey() + "/" + repository.getSlug() + "[" + repository.getId() + "]";
    }
}

