/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity;

import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.migration.entity.UniqueIdentifierGenerator;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SimpleUniqueIdentifierGenerator
implements UniqueIdentifierGenerator {
    static final String IDENTIFIER_FORMAT = "%s_%s";
    static final int MAX_INCREMENT_RETRIES = 50;
    static final int RANDOM_HASH_LENGTH = 10;
    private static final SecureTokenGenerator GENERATOR = DefaultSecureTokenGenerator.getInstance();
    private static final int IDENTIFIER_FORMATTING_LENGTH = String.format("%s_%s", "", "").length();
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("(?<value>.+)_(?<counter>\\d+)");
    private static final Logger log = LoggerFactory.getLogger(SimpleUniqueIdentifierGenerator.class);

    @Override
    @Nonnull
    public Optional<String> getUniqueIdentifier(@Nonnull String identifier, int maxLength, @Nonnull Predicate<String> existsPredicate) {
        String prefix;
        int counter;
        Objects.requireNonNull(existsPredicate, "existsPredicate");
        Objects.requireNonNull(identifier, "identifier");
        boolean exists = existsPredicate.test(identifier);
        if (!exists) {
            log.trace("The provided identifier \"{}\" is already unique.", (Object)identifier);
            return Optional.of(identifier);
        }
        Matcher matcher = IDENTIFIER_PATTERN.matcher(identifier);
        if (matcher.matches()) {
            try {
                counter = Integer.parseInt(matcher.group("counter"));
            }
            catch (NumberFormatException e) {
                counter = 0;
            }
            prefix = matcher.group("value");
        } else {
            counter = 0;
            prefix = identifier;
        }
        String candidate = identifier;
        for (int i = counter + 1; i < 50 + counter + 1 && exists; ++i) {
            candidate = SimpleUniqueIdentifierGenerator.generateCandidate(prefix, Integer.toString(i), maxLength);
            exists = existsPredicate.test(candidate);
        }
        if (exists) {
            String randomHash = GENERATOR.generateToken().substring(0, 10);
            candidate = SimpleUniqueIdentifierGenerator.generateCandidate(prefix, randomHash, maxLength);
            log.debug("No unique identifier could be found using incremental renaming strategy. Generating identifier with random hash suffix instead. Identifier: \"{}\" -> \"{}\".", (Object)identifier, (Object)candidate);
            exists = existsPredicate.test(candidate);
        }
        if (exists) {
            log.debug("No unique identifier could be found for the provided identifier \"{}\".", (Object)identifier);
            return Optional.empty();
        }
        log.debug("Unique identifier found: \"{}\" -> \"{}\".", (Object)identifier, (Object)candidate);
        return Optional.of(candidate);
    }

    private static String generateCandidate(String prefix, String suffix, int maxLength) {
        int maxOriginalValueLength = maxLength - IDENTIFIER_FORMATTING_LENGTH - suffix.length();
        return String.format(IDENTIFIER_FORMAT, StringUtils.left((String)prefix, (int)maxOriginalValueLength), suffix);
    }
}

