/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.comment;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.util.AttachmentUri;
import com.atlassian.stash.internal.migration.entity.comment.CommentMetadata;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AttachmentTransformer {
    private static final Logger log = LoggerFactory.getLogger(AttachmentTransformer.class);
    private final I18nService i18nService;

    public AttachmentTransformer(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    @Nonnull
    public String transformComment(@Nonnull CommentMetadata comment, @Nonnull ImportContext context) {
        return this.transformText(comment.getText(), context);
    }

    @Nonnull
    public String transformText(@Nonnull String text, @Nonnull ImportContext context) {
        Matcher m = AttachmentUri.PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            Optional<AttachmentUri> optionalUri = Optional.ofNullable(AttachmentUri.from((MatchResult)m));
            Optional localRepositoryId = optionalUri.flatMap(uri -> context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(String.valueOf(uri.getRepositoryId())));
            Optional localAttachmentId = optionalUri.flatMap(uri -> context.getEntityMapping(StandardMigrationEntityType.ATTACHMENT).getLocalId(uri.getAttachmentId()));
            if (localRepositoryId.isPresent()) {
                log.debug("Transforming attachment markdown for {}", (Object)text);
                if (localAttachmentId.isPresent()) {
                    m.appendReplacement(sb, new AttachmentUri(((Integer)localRepositoryId.get()).intValue(), ((Long)localAttachmentId.get()).toString()).toString());
                    continue;
                }
                m.appendReplacement(sb, new AttachmentUri(((Integer)localRepositoryId.get()).intValue(), optionalUri.get().getAttachmentId()).toString());
                continue;
            }
            optionalUri.ifPresent(uri -> context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.exportid.missing", new Object[]{uri.getRepositoryId()}), (Object)"pr attachment"));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

