/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.comment;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.migration.EntityExportMapping;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CommentMetadata
implements MigrationMetadata {
    @JsonProperty
    private final String authorId;
    @JsonProperty
    private final List<CommentMetadata> comments;
    @JsonProperty
    private final long createdTimestamp;
    @JsonProperty
    private final String id;
    @JsonProperty
    private Long resolvedTimestamp;
    @JsonProperty
    private String resolverId;
    @JsonProperty
    private final CommentSeverity severity;
    @JsonProperty
    private final CommentState state;
    @JsonProperty
    private final String text;
    @JsonProperty
    private final long updatedTimestamp;

    @JsonCreator
    protected CommentMetadata(@JsonProperty(value="authorId") @Nonnull String authorId, @JsonProperty(value="comments") @Nonnull List<CommentMetadata> comments, @JsonProperty(value="createdTimestamp") long createdTimestamp, @JsonProperty(value="id") @Nonnull String id, @JsonProperty(value="resolvedTimestamp") @Nullable Long resolvedTimestamp, @JsonProperty(value="resolverId") @Nullable String resolverId, @JsonProperty(value="severity") @Nullable CommentSeverity severity, @JsonProperty(value="state") @Nullable CommentState state, @JsonProperty(value="text") @Nonnull String text, @JsonProperty(value="updatedTimestamp") long updatedTimestamp) {
        this.authorId = Objects.requireNonNull(authorId, "authorId");
        this.comments = Objects.requireNonNull(comments, "comments");
        this.createdTimestamp = createdTimestamp;
        this.id = Objects.requireNonNull(id, "id");
        this.resolvedTimestamp = resolvedTimestamp;
        this.resolverId = resolverId;
        this.severity = (CommentSeverity)MoreObjects.firstNonNull((Object)severity, (Object)CommentSeverity.NORMAL);
        this.state = (CommentState)MoreObjects.firstNonNull((Object)state, (Object)CommentState.OPEN);
        this.text = Objects.requireNonNull(text, "text");
        this.updatedTimestamp = updatedTimestamp;
    }

    public CommentMetadata(@Nonnull InternalComment comment, @Nonnull ExportContext exportContext) {
        Objects.requireNonNull(exportContext, "exportContext");
        Objects.requireNonNull(comment, "comment");
        EntityExportMapping commentMapping = exportContext.getEntityMapping(StandardMigrationEntityType.COMMENT);
        EntityExportMapping userMapping = exportContext.getEntityMapping(StandardMigrationEntityType.USER);
        this.authorId = userMapping.getExportId((Object)comment.getAuthor().getId());
        this.comments = comment.getComments().stream().map(reply -> new CommentMetadata(InternalConverter.convertToInternalComment((Comment)reply), exportContext)).collect(Collectors.toList());
        this.createdTimestamp = comment.getCreatedDate().getTime();
        this.id = commentMapping.getExportId((Object)comment.getId());
        if (comment.getResolver() != null && comment.getResolvedDate() != null) {
            this.resolverId = userMapping.getExportId((Object)comment.getResolver().getId());
            this.resolvedTimestamp = comment.getResolvedDate().getTime();
        }
        this.severity = comment.getSeverity();
        this.state = comment.getState();
        this.text = comment.getText();
        this.updatedTimestamp = comment.getUpdatedDate().getTime();
    }

    @Nonnull
    public String getAuthorId() {
        return this.authorId;
    }

    @Nonnull
    public List<CommentMetadata> getComments() {
        return this.comments;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public Long getResolvedTimestamp() {
        return this.resolvedTimestamp;
    }

    public String getResolverId() {
        return this.resolverId;
    }

    public long getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    @Nonnull
    public CommentSeverity getSeverity() {
        return this.severity;
    }

    @Nonnull
    public CommentState getState() {
        return this.state;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"comment").addValue((Object)this.id).add("resolvedTimestamp", (Object)this.resolvedTimestamp).add("resolverId", (Object)this.resolverId).add("severity", (Object)this.severity).add("state", (Object)this.state).add("text.length", this.text.length()).add("comments.size", this.comments.size()).add("created", (Object)MigrationMetadata.formatTimestamp(this.createdTimestamp)).add("updated", (Object)MigrationMetadata.formatTimestamp(this.updatedTimestamp)).toString();
    }
}

