/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.comment;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.stash.internal.comment.InternalCommentThreadDiffAnchor;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class CommentThreadDiffAnchorMetadata
implements MigrationMetadata {
    @JsonProperty
    private final CommentThreadDiffAnchorType diffType;
    @JsonProperty
    private final Integer dstSpanEnd;
    @JsonProperty
    private final Integer dstSpanStart;
    @JsonProperty
    private final DiffFileType fileType;
    @JsonProperty
    private final String fromHash;
    @JsonProperty
    private final int line;
    @JsonProperty
    private final DiffSegmentType lineType;
    @JsonProperty
    private final Integer multilineStartLine;
    @JsonProperty
    private final DiffSegmentType multilineStartLineType;
    @JsonProperty
    private final boolean orphaned;
    @JsonProperty
    private final String path;
    @JsonProperty
    private final String srcPath;
    @JsonProperty
    private final Integer srcSpanEnd;
    @JsonProperty
    private final Integer srcSpanStart;
    @JsonProperty
    private final String toHash;

    @JsonCreator
    public CommentThreadDiffAnchorMetadata(@JsonProperty(value="diffType") @Nonnull CommentThreadDiffAnchorType diffType, @JsonProperty(value="dstSpanEnd") Integer dstSpanEnd, @JsonProperty(value="dstSpanStart") Integer dstSpanStart, @JsonProperty(value="fileType") DiffFileType fileType, @JsonProperty(value="fromHash") String fromHash, @JsonProperty(value="line") int line, @JsonProperty(value="lineType") DiffSegmentType lineType, @JsonProperty(value="multilineStartLine") Integer multilineStartLine, @JsonProperty(value="multilineStartLineType") DiffSegmentType multilineStartLineType, @JsonProperty(value="orphaned") boolean orphaned, @JsonProperty(value="path") @Nonnull String path, @JsonProperty(value="srcPath") String srcPath, @JsonProperty(value="srcSpanEnd") Integer srcSpanEnd, @JsonProperty(value="srcSpanStart") Integer srcSpanStart, @JsonProperty(value="toHash") @Nonnull String toHash) {
        this.diffType = Objects.requireNonNull(diffType, "diffType");
        this.dstSpanEnd = dstSpanEnd;
        this.dstSpanStart = dstSpanStart;
        this.fileType = fileType;
        this.fromHash = fromHash;
        this.line = line;
        this.lineType = lineType;
        this.multilineStartLine = multilineStartLine;
        this.multilineStartLineType = multilineStartLineType;
        this.orphaned = orphaned;
        this.path = Objects.requireNonNull(path, "path");
        this.srcPath = srcPath;
        this.srcSpanEnd = srcSpanEnd;
        this.srcSpanStart = srcSpanStart;
        this.toHash = Objects.requireNonNull(toHash, "toHash");
    }

    public CommentThreadDiffAnchorMetadata(@Nonnull InternalCommentThreadDiffAnchor anchor) {
        Objects.requireNonNull(anchor, "anchor");
        this.diffType = Objects.requireNonNull(anchor.getDiffType(), "diffType");
        this.dstSpanEnd = anchor.getDstSpanEnd().orElse(null);
        this.dstSpanStart = anchor.getDstSpanStart().orElse(null);
        this.multilineStartLine = anchor.getMultilineStartLine().orElse(null);
        this.multilineStartLineType = anchor.getMultilineStartLineType().orElse(null);
        this.fileType = anchor.getFileType().orElse(null);
        this.fromHash = anchor.getFromHash().orElse(null);
        this.line = anchor.getLine();
        this.lineType = anchor.getLineType().orElse(null);
        this.orphaned = anchor.isOrphaned();
        this.path = Objects.requireNonNull(anchor.getPath(), "path");
        this.srcPath = anchor.getSrcPath().orElse(null);
        this.srcSpanEnd = anchor.getSrcSpanEnd().orElse(null);
        this.srcSpanStart = anchor.getSrcSpanStart().orElse(null);
        this.toHash = Objects.requireNonNull(anchor.getToHash(), "toHash");
    }

    @Nonnull
    public CommentThreadDiffAnchorType getDiffType() {
        return this.diffType;
    }

    @Nonnull
    public Optional<Integer> getDstSpanEnd() {
        return Optional.ofNullable(this.dstSpanEnd);
    }

    @Nonnull
    public Optional<Integer> getDstSpanStart() {
        return Optional.ofNullable(this.dstSpanStart);
    }

    @Nonnull
    public Optional<DiffFileType> getFileType() {
        return Optional.ofNullable(this.fileType);
    }

    @Nonnull
    public Optional<String> getFromHash() {
        return Optional.ofNullable(this.fromHash);
    }

    public int getLine() {
        return this.line;
    }

    @Nonnull
    public Optional<DiffSegmentType> getLineType() {
        return Optional.ofNullable(this.lineType);
    }

    public boolean isLineAnchor() {
        return this.line > 0 && this.lineType != null;
    }

    public boolean isMultilineAnchor() {
        return this.isLineAnchor() && (this.srcSpanStart != null && this.srcSpanEnd != null || this.dstSpanStart != null && this.dstSpanEnd != null) && this.multilineStartLine != null && this.multilineStartLineType != null;
    }

    public boolean isOrphaned() {
        return this.orphaned;
    }

    @Nonnull
    public Optional<Integer> getMultilineStartLine() {
        return Optional.ofNullable(this.multilineStartLine);
    }

    @Nonnull
    public Optional<DiffSegmentType> getMultilineStartLineType() {
        return Optional.ofNullable(this.multilineStartLineType);
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Optional<String> getSrcPath() {
        return Optional.ofNullable(this.srcPath);
    }

    @Nonnull
    public Optional<Integer> getSrcSpanEnd() {
        return Optional.ofNullable(this.srcSpanEnd);
    }

    @Nonnull
    public Optional<Integer> getSrcSpanStart() {
        return Optional.ofNullable(this.srcSpanStart);
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"anchor").addValue((Object)this.diffType).addValue((Object)this.fileType).addValue((Object)this.lineType).addValue(this.line == 0 ? null : Integer.valueOf(this.line)).addValue((Object)(this.multilineStartLine == 0 ? null : this.multilineStartLine)).addValue((Object)this.multilineStartLineType).add("srcPath", (Object)this.srcPath).addValue((Object)this.path).add("fromHash", (Object)this.fromHash).addValue((Object)this.toHash).add("orphaned", this.orphaned).omitNullValues().toString();
    }
}

