/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.comment;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.comment.CommentThreadDiffAnchorMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class CommentThreadMetadata
implements MigrationMetadata {
    @JsonProperty
    private final CommentThreadDiffAnchorMetadata anchor;
    @JsonProperty
    private final long createdTimestamp;
    @JsonProperty
    private final boolean resolved;
    @JsonProperty
    private final Long resolvedTimestamp;
    @JsonProperty
    private final String resolverId;
    @JsonProperty
    private final long updatedTimestamp;

    @JsonCreator
    public CommentThreadMetadata(@JsonProperty(value="anchor") CommentThreadDiffAnchorMetadata anchor, @JsonProperty(value="createdTimestamp") long createdTimestamp, @JsonProperty(value="resolved") boolean resolved, @JsonProperty(value="resolvedTimestamp") Long resolvedTimestamp, @JsonProperty(value="resolverId") String resolverId, @JsonProperty(value="updatedTimestamp") long updatedTimestamp) {
        this.anchor = anchor;
        this.createdTimestamp = createdTimestamp;
        this.resolved = resolved;
        this.resolvedTimestamp = resolvedTimestamp;
        this.resolverId = resolverId;
        this.updatedTimestamp = updatedTimestamp;
    }

    public CommentThreadMetadata(@Nonnull InternalCommentThread commentThread, @Nonnull ExportContext exportContext) {
        Objects.requireNonNull(commentThread, "commentThread");
        Objects.requireNonNull(exportContext, "exportContext");
        this.anchor = commentThread.getAnchor().map(internalAnchor -> new CommentThreadDiffAnchorMetadata(InternalConverter.convertToInternalAnchor((CommentThreadDiffAnchor)internalAnchor))).orElse(null);
        this.createdTimestamp = commentThread.getCreatedDate().getTime();
        this.updatedTimestamp = commentThread.getUpdatedDate().getTime();
        this.resolved = commentThread.isResolved();
        if (this.resolved) {
            this.resolverId = Optional.ofNullable(commentThread.getResolver()).map(user -> exportContext.getEntityMapping(StandardMigrationEntityType.USER).getExportId((Object)user.getId())).orElse(null);
            this.resolvedTimestamp = Optional.ofNullable(commentThread.getResolvedDate()).map(Date::getTime).orElse(null);
        } else {
            this.resolverId = null;
            this.resolvedTimestamp = null;
        }
    }

    @Nonnull
    public Optional<CommentThreadDiffAnchorMetadata> getAnchor() {
        return Optional.ofNullable(this.anchor);
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public Long getResolvedTimestamp() {
        return this.resolvedTimestamp;
    }

    public String getResolverId() {
        return this.resolverId;
    }

    public long getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"thread").addValue((Object)this.anchor).add("created", (Object)MigrationMetadata.formatTimestamp(this.createdTimestamp)).add("updated", (Object)MigrationMetadata.formatTimestamp(this.updatedTimestamp)).add("resolved", this.resolved).add("resolvedTimestamp", (Object)this.resolvedTimestamp).add("resolverId", (Object)this.resolverId).omitNullValues().toString();
    }
}

