/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.comment;

import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.comment.CommentMetadata;
import com.atlassian.stash.internal.migration.entity.comment.CommentThreadMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

public class RootCommentMetadata
extends CommentMetadata {
    @JsonProperty
    private final CommentThreadMetadata thread;

    @JsonCreator
    public RootCommentMetadata(@JsonProperty(value="authorId") @Nonnull String authorId, @JsonProperty(value="comments") @Nonnull List<CommentMetadata> comments, @JsonProperty(value="createdTimestamp") long createdTimestamp, @JsonProperty(value="id") @Nonnull String id, @JsonProperty(value="resolvedTimestamp") @Nullable Long resolvedTimestamp, @JsonProperty(value="resolverId") @Nullable String resolverId, @JsonProperty(value="severity") @Nullable CommentSeverity severity, @JsonProperty(value="state") @Nullable CommentState state, @JsonProperty(value="text") @Nonnull String text, @JsonProperty(value="thread") @Nonnull CommentThreadMetadata thread, @JsonProperty(value="updatedTimestamp") long updatedTimestamp) {
        super(authorId, comments, createdTimestamp, id, resolvedTimestamp, resolverId, severity, state, text, updatedTimestamp);
        this.thread = Objects.requireNonNull(thread, "thread");
    }

    public RootCommentMetadata(@Nonnull InternalComment comment, @Nonnull ExportContext exportContext) {
        super(comment, exportContext);
        this.thread = new CommentThreadMetadata(comment.getThread(), exportContext);
    }

    @Nonnull
    public CommentThreadMetadata getThread() {
        return this.thread;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"comment").addValue((Object)this.getId()).addValue((Object)this.getThread()).add("resolvedTimestamp", (Object)this.getResolvedTimestamp()).add("resolverId", (Object)this.getResolverId()).add("severity", (Object)this.getSeverity()).add("state", (Object)this.getState()).add("text.length", this.getText().length()).add("comments.size", this.getComments().size()).add("created", (Object)MigrationMetadata.formatTimestamp(this.getCreatedTimestamp())).add("updated", (Object)MigrationMetadata.formatTimestamp(this.getUpdatedTimestamp())).toString();
    }
}

