/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.project;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class ProjectMetadata
implements MigrationMetadata {
    @JsonProperty
    private final String description;
    @JsonProperty
    private final String id;
    @JsonProperty
    private final String key;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String ownerId;
    @JsonProperty(value="public")
    private final boolean publiclyAccessible;
    @JsonProperty
    private final int type;

    @JsonCreator
    public ProjectMetadata(@JsonProperty(value="description") String description, @JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="owner") String ownerId, @JsonProperty(value="public") boolean publiclyAccessible, @JsonProperty(value="type") int type) {
        this.description = description;
        this.id = Objects.requireNonNull(id, "id");
        this.key = Objects.requireNonNull(key, "key");
        this.name = Objects.requireNonNull(name, "name");
        this.ownerId = ownerId;
        this.publiclyAccessible = publiclyAccessible;
        this.type = type;
    }

    public ProjectMetadata(@Nonnull ExportContext exportContext, @Nonnull Project project) {
        this.description = project.getDescription();
        this.id = exportContext.getEntityMapping(StandardMigrationEntityType.PROJECT).getExportId((Object)project.getId());
        this.key = project.getKey();
        this.name = project.getName();
        this.ownerId = Optional.of(project).filter(PersonalProject.class::isInstance).map(PersonalProject.class::cast).map(personalProject -> exportContext.getEntityMapping(StandardMigrationEntityType.USER).getExportId((Object)personalProject.getOwner().getId())).orElse(null);
        this.publiclyAccessible = project.isPublic();
        this.type = project.getType().getId();
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Optional<String> getOwnerId() {
        return Optional.ofNullable(this.ownerId);
    }

    public int getType() {
        return this.type;
    }

    public boolean isPublic() {
        return this.publiclyAccessible;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"project").addValue((Object)this.id).addValue((Object)this.key).add("ownerId", (Object)this.ownerId).add("type", (Object)ProjectType.fromId((int)this.type)).add("public", this.isPublic()).omitNullValues().toString();
    }
}

