/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.pull.ActivityMetadataVisitor;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestAutoMergeCancelledActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestCommentAddedActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestCommentOtherActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestDraftStatusUpdatedActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestMergeActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestRescopeActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestReviewersUpdatedActivityMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PullRequestActivityMetadata.class, name="ACTIVITY"), @JsonSubTypes.Type(value=PullRequestAutoMergeCancelledActivityMetadata.class, name="AUTOMERGE:CANCELLED"), @JsonSubTypes.Type(value=PullRequestCommentAddedActivityMetadata.class, name="COMMENT:ADDED"), @JsonSubTypes.Type(value=PullRequestCommentOtherActivityMetadata.class, name="COMMENT:OTHER"), @JsonSubTypes.Type(value=PullRequestDraftStatusUpdatedActivityMetadata.class, name="DRAFTSTATUS:UPDATED"), @JsonSubTypes.Type(value=PullRequestMergeActivityMetadata.class, name="MERGED"), @JsonSubTypes.Type(value=PullRequestRescopeActivityMetadata.class, name="RESCOPED"), @JsonSubTypes.Type(value=PullRequestReviewersUpdatedActivityMetadata.class, name="REVIEWERS:UPDATED")})
public abstract class BasePullRequestActivityMetadata
implements MigrationMetadata {
    @JsonProperty
    private final PullRequestAction action;
    @JsonProperty
    private final long createdTimestamp;
    @JsonProperty
    private final String userId;

    protected BasePullRequestActivityMetadata(@Nonnull PullRequestActivity activity, @Nonnull ExportContext exportContext) {
        Objects.requireNonNull(activity, "activity");
        this.action = activity.getAction();
        this.userId = BasePullRequestActivityMetadata.toExportId(exportContext, activity.getUser());
        this.createdTimestamp = activity.getCreatedDate().getTime();
    }

    protected BasePullRequestActivityMetadata(@Nonnull PullRequestAction action, long createdTimestamp, @Nonnull String userId) {
        this.action = Objects.requireNonNull(action, "action");
        this.createdTimestamp = createdTimestamp;
        this.userId = Objects.requireNonNull(userId, "userId");
    }

    @Nonnull
    public PullRequestAction getAction() {
        return this.action;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Nonnull
    public String getUserId() {
        return this.userId;
    }

    abstract void accept(@Nonnull ActivityMetadataVisitor var1);

    protected static String toExportId(ExportContext exportContext, ApplicationUser user) {
        return exportContext.getEntityMapping(StandardMigrationEntityType.USER).getExportId((Object)user.getId());
    }
}

