/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.stash.internal.migration.entity.MigrationEntityIdentifierMapper;
import com.atlassian.stash.internal.migration.entity.pull.ActivityMetadataVisitor;
import com.atlassian.stash.internal.migration.entity.pull.BasePullRequestActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestAutoMergeCancelledActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestCommentAddedActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestCommentOtherActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestDraftStatusUpdatedActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestMergeActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestRescopeActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestReviewersUpdatedActivityMetadata;
import com.atlassian.stash.internal.util.TransactionBatcher;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class BatchingPullRequestActivityVisitor
implements ActivityMetadataVisitor,
Closeable {
    private static final int ACTIVITY_BATCH_SIZE = 250;
    private static final Logger log = LoggerFactory.getLogger(BatchingPullRequestActivityVisitor.class);
    private final I18nService i18nService;
    private final ImportContext importContext;
    private final ActivityMetadataVisitor persister;
    private final PullRequest pullRequest;
    private final TransactionBatcher txBatcher;

    public BatchingPullRequestActivityVisitor(@Nonnull ActivityMetadataVisitor delegateVisitor, @Nonnull I18nService i18nService, @Nonnull ImportContext importContext, @Nonnull PullRequest pullRequest, @Nonnull PlatformTransactionManager transactionManager) {
        this(delegateVisitor, i18nService, importContext, pullRequest, transactionManager, 250);
    }

    public BatchingPullRequestActivityVisitor(@Nonnull ActivityMetadataVisitor delegateVisitor, @Nonnull I18nService i18nService, @Nonnull ImportContext importContext, @Nonnull PullRequest pullRequest, @Nonnull PlatformTransactionManager transactionManager, int activityBatchSize) {
        this.persister = delegateVisitor;
        this.i18nService = i18nService;
        this.importContext = importContext;
        this.pullRequest = pullRequest;
        this.txBatcher = new TransactionBatcher(transactionManager, activityBatchSize, "pr-activity-import");
        this.txBatcher.start();
    }

    @Override
    public void close() {
        if (this.txBatcher.rollback()) {
            log.warn("Rolling back batch of {} activities for {}", (Object)this.txBatcher.getUncommittedCount(), (Object)MigrationEntityIdentifierMapper.getEntityIdentifier((Object)this.pullRequest));
        }
    }

    public void commit() {
        this.txBatcher.commit();
    }

    @Override
    public void visit(@Nonnull PullRequestActivityMetadata activity) {
        this.doInBatch(activity, this.persister::visit);
    }

    @Override
    public void visit(@Nonnull PullRequestAutoMergeCancelledActivityMetadata activity) {
        this.doInBatch(activity, this.persister::visit);
    }

    @Override
    public void visit(@Nonnull PullRequestCommentAddedActivityMetadata activity) {
        this.doInBatch(activity, this.persister::visit);
    }

    @Override
    public void visit(@Nonnull PullRequestCommentOtherActivityMetadata activity) {
        this.doInBatch(activity, this.persister::visit);
    }

    @Override
    public void visit(@Nonnull PullRequestDraftStatusUpdatedActivityMetadata activity) {
        this.doInBatch(activity, this.persister::visit);
    }

    @Override
    public void visit(@Nonnull PullRequestMergeActivityMetadata activity) {
        this.doInBatch(activity, this.persister::visit);
    }

    @Override
    public void visit(@Nonnull PullRequestRescopeActivityMetadata activity) {
        this.doInBatch(activity, this.persister::visit);
    }

    @Override
    public void visit(@Nonnull PullRequestReviewersUpdatedActivityMetadata activity) {
        this.doInBatch(activity, this.persister::visit);
    }

    private <A extends BasePullRequestActivityMetadata> void doInBatch(A activity, Consumer<A> work) {
        try {
            work.accept(activity);
            this.txBatcher.tick();
        }
        catch (RuntimeException e) {
            this.importContext.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.activities.import.batch.failed", new Object[]{MigrationEntityIdentifierMapper.getEntityIdentifier(activity), MigrationEntityIdentifierMapper.getEntityIdentifier((Object)this.pullRequest), e.getMessage()}), (Object)this.pullRequest, (Throwable)e);
            throw e;
        }
    }
}

