/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.pull.AbstractPullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestAutoMergeCancelledActivity;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.pull.PullRequestDraftStatusUpdatedActivity;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.pull.PullRequestReviewersUpdatedActivity;
import com.atlassian.stash.internal.migration.entity.pull.BasePullRequestCommentActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestAutoMergeCancelledActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestCommentAddedActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestCommentOtherActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestDraftStatusUpdatedActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestMergeActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestRescopeActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestReviewersUpdatedActivityMetadata;
import com.fasterxml.jackson.core.JsonGenerator;
import jakarta.annotation.Nonnull;
import java.io.IOException;

public class JsonExportingActivityVisitor
extends AbstractPullRequestActivityVisitor {
    private final ExportContext exportContext;
    private final I18nService i18nService;
    private final JsonGenerator jsonGenerator;

    JsonExportingActivityVisitor(ExportContext exportContext, JsonGenerator jsonGenerator, I18nService i18nService) {
        this.exportContext = exportContext;
        this.jsonGenerator = jsonGenerator;
        this.i18nService = i18nService;
    }

    public void visit(@Nonnull PullRequestActivity activity) {
        try {
            this.jsonGenerator.writeObject((Object)new PullRequestActivityMetadata(activity, this.exportContext));
        }
        catch (IOException e) {
            this.recordError(activity, e);
        }
    }

    public void visit(@Nonnull PullRequestCommentActivity activity) {
        try {
            BasePullRequestCommentActivityMetadata metadata = activity.getCommentAction() == CommentAction.ADDED ? new PullRequestCommentAddedActivityMetadata(activity, this.exportContext) : new PullRequestCommentOtherActivityMetadata(activity, this.exportContext);
            this.jsonGenerator.writeObject((Object)metadata);
        }
        catch (IOException e) {
            this.recordError((PullRequestActivity)activity, e);
        }
    }

    public void visit(@Nonnull PullRequestDraftStatusUpdatedActivity activity) {
        try {
            this.jsonGenerator.writeObject((Object)new PullRequestDraftStatusUpdatedActivityMetadata(activity, this.exportContext));
        }
        catch (IOException e) {
            this.recordError((PullRequestActivity)activity, e);
        }
    }

    public void visit(@Nonnull PullRequestMergeActivity activity) {
        try {
            this.jsonGenerator.writeObject((Object)new PullRequestMergeActivityMetadata(activity, this.exportContext));
        }
        catch (IOException e) {
            this.recordError((PullRequestActivity)activity, e);
        }
    }

    public void visit(@Nonnull PullRequestRescopeActivity activity) {
        try {
            this.jsonGenerator.writeObject((Object)new PullRequestRescopeActivityMetadata(activity, this.exportContext));
        }
        catch (IOException e) {
            this.recordError((PullRequestActivity)activity, e);
        }
    }

    public void visit(@Nonnull PullRequestReviewersUpdatedActivity activity) {
        try {
            this.jsonGenerator.writeObject((Object)new PullRequestReviewersUpdatedActivityMetadata(activity, this.exportContext));
        }
        catch (IOException e) {
            this.recordError((PullRequestActivity)activity, e);
        }
    }

    public void visit(@Nonnull PullRequestAutoMergeCancelledActivity activity) {
        try {
            this.jsonGenerator.writeObject((Object)new PullRequestAutoMergeCancelledActivityMetadata(activity, this.exportContext));
        }
        catch (IOException e) {
            this.recordError((PullRequestActivity)activity, e);
        }
    }

    private void recordError(@Nonnull PullRequestActivity activity, IOException e) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.migration.export.json.serialization.failed", new Object[]{activity.getId()});
        this.exportContext.addError(message, (Object)activity, (Throwable)e);
    }
}

