/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.CommentThreadDao;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.comment.InternalCommentThreadDiffAnchor;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.migration.UserImportService;
import com.atlassian.stash.internal.migration.entity.MigrationEntityIdentifierMapper;
import com.atlassian.stash.internal.migration.entity.comment.AttachmentTransformer;
import com.atlassian.stash.internal.migration.entity.comment.CommentMetadata;
import com.atlassian.stash.internal.migration.entity.comment.CommentThreadDiffAnchorMetadata;
import com.atlassian.stash.internal.migration.entity.comment.CommentThreadMetadata;
import com.atlassian.stash.internal.migration.entity.comment.RootCommentMetadata;
import com.atlassian.stash.internal.migration.entity.pull.ActivityMetadataVisitor;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestAutoMergeCancelledActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestCommentAddedActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestCommentOtherActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestDraftStatusUpdatedActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestMergeActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestRescopeActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestReviewersUpdatedActivityMetadata;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestAutoMergeCancelledActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestMergeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestPhase;
import com.atlassian.stash.internal.pull.InternalPullRequestPhaseActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.atlassian.stash.internal.pull.InternalPullRequestReviewersUpdatedActivity;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistingPullRequestActivityVisitor
implements ActivityMetadataVisitor {
    private static final Logger log = LoggerFactory.getLogger(PersistingPullRequestActivityVisitor.class);
    private final AttachmentTransformer attachmentTransformer;
    private final CommentDao commentDao;
    private final I18nService i18nService;
    private final ImportContext importContext;
    private final InternalPullRequest pullRequest;
    private final PullRequestActivityDao pullRequestActivityDao;
    private final CommentThreadDao threadDao;
    private final UserImportService userImportService;

    PersistingPullRequestActivityVisitor(AttachmentTransformer attachmentTransformer, CommentDao commentDao, I18nService i18nService, ImportContext importContext, InternalPullRequest pullRequest, PullRequestActivityDao pullRequestActivityDao, CommentThreadDao threadDao, UserImportService userImportService) {
        this.attachmentTransformer = attachmentTransformer;
        this.commentDao = commentDao;
        this.i18nService = i18nService;
        this.importContext = importContext;
        this.pullRequest = pullRequest;
        this.pullRequestActivityDao = pullRequestActivityDao;
        this.threadDao = threadDao;
        this.userImportService = userImportService;
    }

    @Override
    public void visit(@Nonnull PullRequestActivityMetadata activity) {
        Objects.requireNonNull(activity, "activity");
        InternalApplicationUser user = this.getUser(activity.getUserId());
        this.createActivity(((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)new InternalPullRequestActivity.Builder(this.pullRequest).action(activity.getAction())).createdDate(new Date(activity.getCreatedTimestamp()))).user(user)).build());
    }

    @Override
    public void visit(@Nonnull PullRequestAutoMergeCancelledActivityMetadata activity) {
        Objects.requireNonNull(activity, "activity");
        this.createActivity((InternalPullRequestActivity)((InternalPullRequestAutoMergeCancelledActivity.Builder)((InternalPullRequestAutoMergeCancelledActivity.Builder)((InternalPullRequestAutoMergeCancelledActivity.Builder)new InternalPullRequestAutoMergeCancelledActivity.Builder(this.pullRequest).action(activity.getAction())).cancelledReason(activity.getCancelledReason()).createdDate(new Date(activity.getCreatedTimestamp()))).user(this.getUser(activity.getUserId()))).build());
    }

    @Override
    public void visit(@Nonnull PullRequestCommentAddedActivityMetadata activity) {
        Objects.requireNonNull(activity, "activity");
        InternalComment root = this.createMaybeAnchoredThreadWithRootComment(activity.getComment());
        this.createReplies(root, activity.getComment().getComments());
        this.createActivity((InternalPullRequestActivity)((InternalPullRequestCommentActivity.Builder)((InternalPullRequestCommentActivity.Builder)((InternalPullRequestCommentActivity.Builder)new InternalPullRequestCommentActivity.Builder(this.pullRequest).action(activity.getAction())).comment(root).commentAction(activity.getCommentAction()).createdDate(new Date(activity.getCreatedTimestamp()))).user(this.getUser(activity.getUserId()))).build());
    }

    @Override
    public void visit(@Nonnull PullRequestCommentOtherActivityMetadata activity) {
        Objects.requireNonNull(activity, "activity");
        InternalComment comment = this.getImportedComment(activity.getCommentId());
        if (comment == null) {
            String pullRequestIdentifier = MigrationEntityIdentifierMapper.getPullRequestIdentifier((Repository)this.pullRequest.getScopeRepository(), this.pullRequest.getScopedId());
            this.importContext.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.activities.import.comment.not.found", new Object[]{activity, pullRequestIdentifier}), (Object)this.pullRequest);
            return;
        }
        this.createActivity((InternalPullRequestActivity)((InternalPullRequestCommentActivity.Builder)((InternalPullRequestCommentActivity.Builder)((InternalPullRequestCommentActivity.Builder)new InternalPullRequestCommentActivity.Builder(this.pullRequest).action(activity.getAction())).comment(comment).commentAction(activity.getCommentAction()).createdDate(new Date(activity.getCreatedTimestamp()))).user(this.getUser(activity.getUserId()))).build());
    }

    @Override
    public void visit(@Nonnull PullRequestDraftStatusUpdatedActivityMetadata activity) {
        Objects.requireNonNull(activity, "activity");
        this.createActivity((InternalPullRequestActivity)((InternalPullRequestPhaseActivity.Builder)((InternalPullRequestPhaseActivity.Builder)new InternalPullRequestPhaseActivity.Builder(this.pullRequest).user(this.getUser(activity.getUserId()))).createdDate(new Date(activity.getCreatedTimestamp()))).phase(activity.isDraft() ? InternalPullRequestPhase.DRAFT : InternalPullRequestPhase.PUBLISHED).build());
    }

    @Override
    public void visit(@Nonnull PullRequestMergeActivityMetadata activity) {
        Objects.requireNonNull(activity, "activity");
        this.createActivity((InternalPullRequestActivity)((InternalPullRequestMergeActivity.Builder)((InternalPullRequestMergeActivity.Builder)((InternalPullRequestMergeActivity.Builder)new InternalPullRequestMergeActivity.Builder(this.pullRequest).user(this.getUser(activity.getUserId()))).createdDate(new Date(activity.getCreatedTimestamp()))).action(activity.getAction())).autoMerge(activity.isAutoMerge()).hash(activity.getHash()).build());
    }

    @Override
    public void visit(@Nonnull PullRequestRescopeActivityMetadata activity) {
        Objects.requireNonNull(activity, "activity");
        InternalPullRequestRescopeActivity.Builder builder = (InternalPullRequestRescopeActivity.Builder)((InternalPullRequestRescopeActivity.Builder)((InternalPullRequestRescopeActivity.Builder)new InternalPullRequestRescopeActivity.Builder(this.pullRequest).action(activity.getAction())).commits((Iterable)activity.getCommits().stream().map(commitMetadata -> new InternalPullRequestRescopeCommit.Builder().action(commitMetadata.getAction()).commitId(commitMetadata.getCommitId()).build()).collect(MoreCollectors.toImmutableList())).createdDate(new Date(activity.getCreatedTimestamp()))).fromHash(activity.getFromHash()).previousFromHash(activity.getPreviousFromHash()).previousToHash(activity.getPreviousToHash()).toHash(activity.getToHash()).user(this.getUser(activity.getUserId()));
        activity.getTotalAdded().ifPresent(arg_0 -> ((InternalPullRequestRescopeActivity.Builder)builder).totalAdded(arg_0));
        activity.getTotalRemoved().ifPresent(arg_0 -> ((InternalPullRequestRescopeActivity.Builder)builder).totalRemoved(arg_0));
        this.createActivity((InternalPullRequestActivity)builder.build());
    }

    @Override
    public void visit(@Nonnull PullRequestReviewersUpdatedActivityMetadata activity) {
        Objects.requireNonNull(activity, "activity");
        this.createActivity((InternalPullRequestActivity)((InternalPullRequestReviewersUpdatedActivity.Builder)((InternalPullRequestReviewersUpdatedActivity.Builder)((InternalPullRequestReviewersUpdatedActivity.Builder)new InternalPullRequestReviewersUpdatedActivity.Builder(this.pullRequest).action(activity.getAction())).addedReviewers((Iterable)activity.getAddedIds().stream().map(this::getUser).collect(MoreCollectors.toImmutableList())).createdDate(new Date(activity.getCreatedTimestamp()))).removedReviewers((Iterable)activity.getRemovedIds().stream().map(this::getUser).collect(MoreCollectors.toImmutableList())).user(this.getUser(activity.getUserId()))).build());
    }

    private void createActivity(InternalPullRequestActivity activity) {
        if (log.isDebugEnabled()) {
            log.debug("Created activity {} for pull request {}", (Object)MoreObjects.toStringHelper((Object)activity).add("id", activity.getId()).add("type", activity.getType()).add("action", (Object)activity.getAction()).add("user", (Object)MoreObjects.toStringHelper((Object)activity.getUser()).addValue(activity.getUser().getId()).toString()).add("createdDate", (Object)activity.getCreatedDate()).toString(), (Object)MigrationEntityIdentifierMapper.getEntityIdentifier(this.pullRequest));
        }
        this.pullRequestActivityDao.create((Object)activity);
    }

    private InternalComment createMaybeAnchoredThreadWithRootComment(RootCommentMetadata rootCommentMetadata) {
        CommentThreadMetadata threadMeta = rootCommentMetadata.getThread();
        InternalComment.Builder builder = new InternalComment.Builder().author(this.getUser(rootCommentMetadata.getAuthorId())).createdDate(new Date(rootCommentMetadata.getCreatedTimestamp())).severity(rootCommentMetadata.getSeverity()).state(rootCommentMetadata.getState()).text(this.attachmentTransformer.transformComment(rootCommentMetadata, this.importContext)).updatedDate(new Date(rootCommentMetadata.getUpdatedTimestamp()));
        if (rootCommentMetadata.getResolverId() != null && rootCommentMetadata.getResolvedTimestamp() != null) {
            builder.resolvedDate(new Date(rootCommentMetadata.getResolvedTimestamp())).resolve(this.getUser(rootCommentMetadata.getResolverId()));
        }
        InternalComment rootComment = this.commentDao.importComment(builder.build());
        this.importContext.getEntityMapping(StandardMigrationEntityType.COMMENT).add(rootCommentMetadata.getId(), (Object)rootComment.getId());
        if (log.isDebugEnabled()) {
            log.debug("Created root comment {} in pull request {} for imported root comment {}", new Object[]{rootComment.getId(), MigrationEntityIdentifierMapper.getEntityIdentifier(this.pullRequest), rootCommentMetadata.getId()});
        }
        InternalCommentThreadDiffAnchor anchor = threadMeta.getAnchor().map(this::newAnchor).orElse(null);
        InternalCommentThread.Builder threadBuilder = new InternalCommentThread.Builder((InternalCommentable)this.pullRequest, rootComment).anchor(anchor).updatedDate(new Date(threadMeta.getUpdatedTimestamp()));
        if (threadMeta.isResolved()) {
            threadBuilder.resolve(this.nullOrDate(threadMeta.getResolvedTimestamp()), this.nullOrUser(threadMeta.getResolverId()));
        }
        InternalCommentThread thread = this.threadDao.importThread(threadBuilder.build());
        if (log.isDebugEnabled()) {
            log.debug("Created thread {} for root comment {} in pull request {} with anchor {}", new Object[]{thread.getId(), rootComment.getId(), MigrationEntityIdentifierMapper.getEntityIdentifier(this.pullRequest), this.describeAnchor(anchor)});
        }
        return (InternalComment)this.commentDao.update((Object)new InternalComment.Builder(rootComment).thread(thread).build());
    }

    private void createReplies(InternalComment comment, List<CommentMetadata> repliesMetadata) {
        for (CommentMetadata replyMetadata : repliesMetadata) {
            InternalComment.Builder builder = new InternalComment.Builder().author(this.getUser(replyMetadata.getAuthorId())).createdDate(new Date(replyMetadata.getCreatedTimestamp())).severity(replyMetadata.getSeverity()).state(replyMetadata.getState()).text(this.attachmentTransformer.transformComment(replyMetadata, this.importContext)).updatedDate(new Date(replyMetadata.getUpdatedTimestamp())).parent(comment).thread(comment.getThread());
            if (replyMetadata.getResolverId() != null && replyMetadata.getResolvedTimestamp() != null) {
                builder.resolvedDate(new Date(replyMetadata.getResolvedTimestamp())).resolve(this.getUser(replyMetadata.getResolverId()));
            }
            InternalComment reply = this.commentDao.importComment(builder.build());
            this.importContext.getEntityMapping(StandardMigrationEntityType.COMMENT).add(replyMetadata.getId(), (Object)reply.getId());
            if (log.isDebugEnabled()) {
                log.debug("Created reply {} to comment {} in pull request {} for imported reply {}", new Object[]{reply.getId(), comment.getId(), MigrationEntityIdentifierMapper.getEntityIdentifier(this.pullRequest), replyMetadata.getId()});
            }
            this.createReplies(reply, replyMetadata.getComments());
        }
    }

    private String describeAnchor(InternalCommentThreadDiffAnchor anchor) {
        if (anchor == null) {
            return null;
        }
        MoreObjects.ToStringHelper anchorDescription = MoreObjects.toStringHelper((Object)anchor).add("diffType", (Object)anchor.getDiffType()).add("orphaned", anchor.isOrphaned());
        if (anchor.getSrcPath().isPresent()) {
            anchorDescription.add("fromHash", anchor.getFromHash().get());
        }
        anchorDescription.add("toHash", (Object)anchor.getToHash());
        if (anchor.isLineAnchor()) {
            anchorDescription.add("line", anchor.getLine()).add("lineType", anchor.getLineType().orElse(null));
        } else {
            anchorDescription.add("fileType", (Object)anchor.getFileType());
        }
        return anchorDescription.toString();
    }

    private InternalComment getImportedComment(String exportId) {
        return this.importContext.getEntityMapping(StandardMigrationEntityType.COMMENT).getLocalId(exportId).map(arg_0 -> ((CommentDao)this.commentDao).getById(arg_0)).map(InternalConverter::convertToInternalComment).orElse(null);
    }

    private InternalApplicationUser getUser(String userId) {
        return InternalConverter.convertToInternalUser((ApplicationUser)this.userImportService.findOrCreateUser(userId, this.importContext));
    }

    private InternalCommentThreadDiffAnchor newAnchor(CommentThreadDiffAnchorMetadata anchorMetadata) {
        InternalCommentThreadDiffAnchor.Builder anchorBuilder = new InternalCommentThreadDiffAnchor.Builder(anchorMetadata.getDiffType(), anchorMetadata.getPath(), anchorMetadata.getToHash());
        anchorBuilder.orphaned(anchorMetadata.isOrphaned());
        if (anchorMetadata.isLineAnchor()) {
            anchorBuilder.line(anchorMetadata.getLine(), anchorMetadata.getLineType().get(), anchorMetadata.getFileType().get());
            if (anchorMetadata.isMultilineAnchor()) {
                anchorBuilder.multiline(anchorMetadata.getMultilineStartLine().get().intValue(), anchorMetadata.getMultilineStartLineType().get());
                anchorMetadata.getSrcSpanStart().ifPresent(srcSpanStart -> anchorBuilder.srcSpan(srcSpanStart.intValue(), anchorMetadata.getSrcSpanEnd().get().intValue()));
                anchorMetadata.getDstSpanStart().ifPresent(dstSpanStart -> anchorBuilder.dstSpan(dstSpanStart.intValue(), anchorMetadata.getDstSpanEnd().get().intValue()));
            }
        }
        anchorMetadata.getFromHash().ifPresent(arg_0 -> ((InternalCommentThreadDiffAnchor.Builder)anchorBuilder).fromHash(arg_0));
        anchorMetadata.getSrcPath().ifPresent(arg_0 -> ((InternalCommentThreadDiffAnchor.Builder)anchorBuilder).srcPath(arg_0));
        return anchorBuilder.build();
    }

    private Date nullOrDate(Long resolvedTimestamp) {
        return resolvedTimestamp == null ? null : new Date(resolvedTimestamp);
    }

    private InternalApplicationUser nullOrUser(String resolverId) {
        return resolverId == null ? null : this.getUser(resolverId);
    }
}

