/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.CommentThreadDao;
import com.atlassian.stash.internal.migration.UserImportService;
import com.atlassian.stash.internal.migration.entity.MigrationEntityIdentifierMapper;
import com.atlassian.stash.internal.migration.entity.comment.AttachmentTransformer;
import com.atlassian.stash.internal.migration.entity.pull.BasePullRequestActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.BatchingPullRequestActivityVisitor;
import com.atlassian.stash.internal.migration.entity.pull.PersistingPullRequestActivityVisitor;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PullRequestActivityImporter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(PullRequestActivityImporter.class);
    private final AttachmentTransformer attachmentTransformer;
    private final CommentDao commentDao;
    private final I18nService i18nService;
    private final PullRequestActivityDao pullRequestActivityDao;
    private final InternalPullRequestService pullRequestService;
    private final CommentThreadDao threadDao;
    private final PlatformTransactionManager transactionManager;
    private final UserImportService userImportService;

    @Autowired
    public PullRequestActivityImporter(AttachmentTransformer attachmentTransformer, CommentDao commentDao, I18nService i18nService, PullRequestActivityDao pullRequestActivityDao, InternalPullRequestService pullRequestService, UserImportService userImportService, CommentThreadDao threadDao, PlatformTransactionManager transactionManager) {
        this.attachmentTransformer = attachmentTransformer;
        this.commentDao = commentDao;
        this.pullRequestService = pullRequestService;
        this.pullRequestActivityDao = pullRequestActivityDao;
        this.i18nService = i18nService;
        this.userImportService = userImportService;
        this.transactionManager = transactionManager;
        this.threadDao = threadDao;
    }

    @Transactional(propagation=Propagation.NEVER)
    public void importActivities(@Nonnull ImportContext context, @Nonnull EntrySource entry, @Nonnull Repository repo, long scopedId) throws IOException {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(entry, "entry");
        Objects.requireNonNull(repo, "repo");
        log.debug("Importing activities for pull request {}", (Object)MigrationEntityIdentifierMapper.getPullRequestIdentifier(repo, scopedId));
        InternalPullRequest pr = InternalConverter.convertToInternalPullRequest((PullRequest)this.pullRequestService.getById(repo.getId(), scopedId));
        if (pr == null) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.activities.import.pullrequest.not.found", new Object[]{MigrationEntityIdentifierMapper.getPullRequestIdentifier(repo, scopedId)}), (Object)repo);
        }
        ArrayList activitiesMetadata = new ArrayList();
        entry.read(inputStream -> this.readAllActivitiesOrFail(activitiesMetadata, (InputStream)inputStream, (PullRequest)pr));
        if (activitiesMetadata.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Pull request {} has no activities to import", (Object)MigrationEntityIdentifierMapper.getEntityIdentifier(pr));
            }
            return;
        }
        PersistingPullRequestActivityVisitor persister = new PersistingPullRequestActivityVisitor(this.attachmentTransformer, this.commentDao, this.i18nService, context, pr, this.pullRequestActivityDao, this.threadDao, this.userImportService);
        try (BatchingPullRequestActivityVisitor batchingPersister = new BatchingPullRequestActivityVisitor(persister, this.i18nService, context, (PullRequest)pr, this.transactionManager);){
            activitiesMetadata.forEach(activity -> activity.accept(batchingPersister));
            batchingPersister.commit();
        }
    }

    private void readAllActivitiesOrFail(List<BasePullRequestActivityMetadata> activitiesMetadata, InputStream inputStream, PullRequest pullRequest) {
        try {
            activitiesMetadata.addAll((Collection)OBJECT_MAPPER.readValue(inputStream, (TypeReference)new TypeReference<List<BasePullRequestActivityMetadata>>(this){}));
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.activities.import.read.failed", new Object[]{MigrationEntityIdentifierMapper.getEntityIdentifier((Object)pullRequest), e.getMessage()}), (Object)pullRequest, (Throwable)e);
        }
    }
}

