/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.pull.AutoMergeCancelledReason;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestAutoMergeCancelledActivity;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.pull.ActivityMetadataVisitor;
import com.atlassian.stash.internal.migration.entity.pull.BasePullRequestActivityMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@JsonIgnoreProperties(value={"action"}, ignoreUnknown=true)
public class PullRequestAutoMergeCancelledActivityMetadata
extends BasePullRequestActivityMetadata {
    @JsonProperty
    private final AutoMergeCancelledReason cancelledReason;

    @JsonCreator
    public PullRequestAutoMergeCancelledActivityMetadata(@JsonProperty(value="createdTimestamp") long createdTimestamp, @JsonProperty(value="userId") @Nonnull String userId, @JsonProperty(value="cancelledReason") @Nonnull AutoMergeCancelledReason cancelledReason) {
        super(PullRequestAction.AUTO_MERGE_CANCELLED, createdTimestamp, userId);
        this.cancelledReason = Objects.requireNonNull(cancelledReason, "cancelledReason");
    }

    public PullRequestAutoMergeCancelledActivityMetadata(@Nonnull PullRequestAutoMergeCancelledActivity activity, @Nonnull ExportContext exportContext) {
        super((PullRequestActivity)activity, exportContext);
        this.cancelledReason = activity.getCancelledReason();
    }

    @Nonnull
    public AutoMergeCancelledReason getCancelledReason() {
        return this.cancelledReason;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"activity").addValue((Object)"automerge:cancelled").add("created", (Object)MigrationMetadata.formatTimestamp(this.getCreatedTimestamp())).add("userId", (Object)this.getUserId()).add("cancelledReason", (Object)this.cancelledReason).toString();
    }

    @Override
    void accept(@Nonnull ActivityMetadataVisitor visitor) {
        visitor.visit(this);
    }
}

