/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.comment.RootCommentMetadata;
import com.atlassian.stash.internal.migration.entity.pull.ActivityMetadataVisitor;
import com.atlassian.stash.internal.migration.entity.pull.BasePullRequestCommentActivityMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@JsonIgnoreProperties(value={"action", "commentAction"}, ignoreUnknown=true)
public class PullRequestCommentAddedActivityMetadata
extends BasePullRequestCommentActivityMetadata {
    @JsonProperty
    private final RootCommentMetadata comment;

    @JsonCreator
    public PullRequestCommentAddedActivityMetadata(@JsonProperty(value="createdTimestamp") long createdTimestamp, @JsonProperty(value="userId") @Nonnull String userId, @JsonProperty(value="comment") @Nonnull RootCommentMetadata comment) {
        super(createdTimestamp, userId, CommentAction.ADDED);
        this.comment = Objects.requireNonNull(comment, "comment");
    }

    public PullRequestCommentAddedActivityMetadata(@Nonnull PullRequestCommentActivity activity, @Nonnull ExportContext exportContext) {
        super(activity, exportContext);
        this.comment = new RootCommentMetadata(InternalConverter.convertToInternalComment((Comment)activity.getComment()), exportContext);
    }

    @Override
    void accept(@Nonnull ActivityMetadataVisitor visitor) {
        Objects.requireNonNull(visitor, "visitor").visit(this);
    }

    @Nonnull
    public RootCommentMetadata getComment() {
        return this.comment;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"activity").addValue((Object)"comment:added").add("created", (Object)MigrationMetadata.formatTimestamp(this.getCreatedTimestamp())).add("userId", (Object)this.getUserId()).addValue((Object)this.comment).omitNullValues().toString();
    }
}

