/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.pull.ActivityMetadataVisitor;
import com.atlassian.stash.internal.migration.entity.pull.BasePullRequestCommentActivityMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Objects;

public class PullRequestCommentOtherActivityMetadata
extends BasePullRequestCommentActivityMetadata {
    @JsonProperty
    private final String commentId;

    @JsonCreator
    public PullRequestCommentOtherActivityMetadata(@JsonProperty(value="createdTimestamp") long createdTimestamp, @JsonProperty(value="userId") @Nonnull String userId, @JsonProperty(value="commentAction") @Nonnull CommentAction commentAction, @JsonProperty(value="commentId") @Nonnull String commentId) {
        super(createdTimestamp, userId, commentAction);
        this.commentId = Objects.requireNonNull(commentId, "commentId");
    }

    public PullRequestCommentOtherActivityMetadata(@Nonnull PullRequestCommentActivity activity, @Nonnull ExportContext context) {
        super(activity, context);
        this.commentId = context.getEntityMapping(StandardMigrationEntityType.COMMENT).getExportId((Object)activity.getComment().getId());
    }

    @Override
    @JsonProperty(value="commentAction")
    @Nonnull
    public CommentAction getCommentAction() {
        return super.getCommentAction();
    }

    @Nonnull
    public String getCommentId() {
        return this.commentId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"activity").addValue((Object)("comment:" + this.getCommentAction().name().toLowerCase(Locale.ROOT))).add("created", (Object)MigrationMetadata.formatTimestamp(this.getCreatedTimestamp())).add("userId", (Object)this.getUserId()).add("commentId", (Object)this.commentId).omitNullValues().toString();
    }

    @Override
    void accept(@Nonnull ActivityMetadataVisitor visitor) {
        Objects.requireNonNull(visitor, "visitor").visit(this);
    }
}

