/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestDraftStatusUpdatedActivity;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.pull.ActivityMetadataVisitor;
import com.atlassian.stash.internal.migration.entity.pull.BasePullRequestActivityMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;

@JsonIgnoreProperties(value={"action"}, ignoreUnknown=true)
public class PullRequestDraftStatusUpdatedActivityMetadata
extends BasePullRequestActivityMetadata {
    @JsonProperty
    private final boolean draft;

    @JsonCreator
    public PullRequestDraftStatusUpdatedActivityMetadata(@JsonProperty(value="createdTimestamp") long createdTimestamp, @JsonProperty(value="userId") @Nonnull String userId, @JsonProperty(value="draft") boolean draft) {
        super(PullRequestAction.UPDATED, createdTimestamp, userId);
        this.draft = draft;
    }

    public PullRequestDraftStatusUpdatedActivityMetadata(@Nonnull PullRequestDraftStatusUpdatedActivity activity, @Nonnull ExportContext exportContext) {
        super((PullRequestActivity)activity, exportContext);
        this.draft = activity.isDraft();
    }

    public boolean isDraft() {
        return this.draft;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"activity").addValue((Object)"draftstatus:updated").add("created", (Object)MigrationMetadata.formatTimestamp(this.getCreatedTimestamp())).add("userId", (Object)this.getUserId()).add("draft", this.draft).toString();
    }

    @Override
    void accept(@Nonnull ActivityMetadataVisitor visitor) {
        visitor.visit(this);
    }
}

