/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.migration.entity.pull.JsonExportingActivityVisitor;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestMetadata;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;

public class PullRequestExporter
implements Exporter {
    private static final int ACTIVITY_BATCH_SIZE = 50;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final I18nService i18nService;
    private final InternalPullRequestService pullRequestService;

    public PullRequestExporter(@Nonnull I18nService i18nService, @Nonnull InternalPullRequestService pullRequestService) {
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.pullRequestService = Objects.requireNonNull(pullRequestService, "pullRequestService");
    }

    public void export(@Nonnull ExportContext context, @Nonnull PullRequest pullRequest) {
        Path basePath = this.getBasePath(context, pullRequest);
        this.exportMetadata(context, pullRequest, basePath.resolve(MigrationPaths.METADATA_PATH));
        this.exportActivities(context, pullRequest, basePath.resolve(MigrationPaths.ACTIVITY_PATH));
    }

    private void exportActivities(@Nonnull ExportContext context, final @Nonnull PullRequest pullRequest, Path path) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(pullRequest, "pullRequest");
        context.addEntry(path, outputStream -> {
            try (JsonGenerator jsonGenerator = this.newJsonGenerator((OutputStream)outputStream);){
                JsonExportingActivityVisitor visitor = new JsonExportingActivityVisitor(context, jsonGenerator, this.i18nService);
                jsonGenerator.writeStartArray();
                PageUtils.toStream((PageProvider)new PageProvider<PullRequestActivity>(){

                    @Nonnull
                    public Page<PullRequestActivity> get(@Nonnull PageRequest request) {
                        return PullRequestExporter.this.pullRequestService.exportActivities(InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).getGlobalId(), request);
                    }
                }, (int)50).forEach(activity -> activity.accept((PullRequestActivityVisitor)visitor));
                jsonGenerator.writeEndArray();
            }
        }, true);
    }

    private void exportMetadata(ExportContext context, PullRequest pullRequest, Path path) {
        PullRequestMetadata metadata = new PullRequestMetadata(InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest), context);
        context.addEntry(path, outputStream -> OBJECT_MAPPER.writeValue(outputStream, (Object)metadata), true);
    }

    private Path getBasePath(ExportContext context, PullRequest pullRequest) {
        String exportRepoId = context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getExportId((Object)pullRequest.getToRef().getRepository().getId());
        return MigrationPaths.REPO_PATH_PREFIX.resolve(exportRepoId).resolve(MigrationPaths.PULL_REQUEST_PATH_PREFIX).resolve(Long.toString(pullRequest.getId()));
    }

    private JsonGenerator newJsonGenerator(OutputStream outputStream) throws IOException {
        JsonGenerator generator = new JsonFactory().createJsonGenerator(outputStream);
        generator.setCodec((ObjectCodec)OBJECT_MAPPER);
        return generator;
    }
}

