/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestActivityImporter;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestMetadataImporter;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class PullRequestImporter
implements Importer {
    private final I18nService i18nService;
    private final PullRequestActivityImporter pullRequestActivityImporter;
    private final PullRequestMetadataImporter pullRequestMetadataImporter;
    private final InternalPullRequestService pullRequestService;
    private final RepositoryService repositoryService;

    public PullRequestImporter(I18nService i18nService, PullRequestActivityImporter pullRequestActivityImporter, PullRequestMetadataImporter pullRequestMetadataImporter, InternalPullRequestService pullRequestService, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
        this.pullRequestActivityImporter = pullRequestActivityImporter;
        this.pullRequestMetadataImporter = pullRequestMetadataImporter;
    }

    public void finalizeRepositoryImport(@Nonnull ImportContext context, @Nonnull Repository repository) {
        try {
            this.pullRequestService.resyncNextId(repository);
        }
        catch (Exception e) {
            throw this.throwNextIdOutOfSync(repository, e);
        }
    }

    public void onEntry(@Nonnull ImportContext context, @Nonnull EntrySource entry) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(entry, "entry");
        Path path = entry.getPath();
        try {
            Path suffix = this.getPrEntrySuffix(path);
            if (MigrationPaths.METADATA_PATH.equals(suffix)) {
                Repository toRepo = this.resolveToRepoFromPath(context, path);
                this.pullRequestMetadataImporter.importPullRequest(context, entry, toRepo, this.getScopedId(path, toRepo));
            } else if (MigrationPaths.ACTIVITY_PATH.equals(suffix)) {
                Repository toRepo = this.resolveToRepoFromPath(context, path);
                this.pullRequestActivityImporter.importActivities(context, entry, toRepo, this.getScopedId(path, toRepo));
            } else {
                this.warnPathUnexpected(context, path);
            }
        }
        catch (ImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.throwImportFailed(path, e);
        }
    }

    private String getEntryFriendlyName(@Nonnull Path path) {
        return Optional.ofNullable(this.getPrEntrySuffix(path)).flatMap(entry -> {
            if (MigrationPaths.METADATA_PATH.equals(entry)) {
                return Optional.of(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.metadata", new Object[0]));
            }
            return Optional.empty();
        }).orElseGet(() -> this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.data", new Object[0])).getRootMessage();
    }

    @Nullable
    private Path getPrEntrySuffix(Path path) {
        return this.hasPrEntryPrefix(path) ? path.subpath(4, path.getNameCount()) : null;
    }

    private Optional<Repository> getRepository(ImportContext context, String exportId) {
        return context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(exportId).map(arg_0 -> ((RepositoryService)this.repositoryService).getById(arg_0));
    }

    private long getScopedId(Path path, Repository toRepo) {
        String scopedId = path.getName(3).toString();
        try {
            return Long.valueOf(scopedId);
        }
        catch (NumberFormatException e) {
            throw this.throwPathScopedIdInvalid(path, toRepo);
        }
    }

    private boolean hasPrEntryPrefix(Path path) {
        return this.hasPrPrefix(path) && path.getNameCount() >= 5 && StringUtils.isNumeric((CharSequence)path.getName(3).toString());
    }

    private boolean hasPrPrefix(Path path) {
        return path.getNameCount() >= 3 && MigrationPaths.REPO_PATH_PREFIX.equals(path.getName(0)) && StringUtils.isNumeric((CharSequence)path.getName(1).toString()) && MigrationPaths.PULL_REQUEST_PATH_PREFIX.equals(path.getName(2));
    }

    private Repository resolveToRepoFromPath(ImportContext context, Path path) {
        String exportId = path.getName(1).toString();
        return this.getRepository(context, exportId).orElseThrow(() -> this.throwToRepoNotFound(path, exportId));
    }

    private ImportException throwImportFailed(Path path, Exception e) {
        throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.unexpectedly.failed", new Object[]{this.getEntryFriendlyName(path), path, e.getMessage()}), null, (Throwable)e);
    }

    private ImportException throwNextIdOutOfSync(Repository repo, Exception e) {
        throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.next.id.out.of.sync", new Object[]{repo, e.getMessage()}), (Object)repo, (Throwable)e);
    }

    private ImportException throwPathScopedIdInvalid(Path path, Repository toRepo) {
        throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.scoped.id.invalid", new Object[]{this.getEntryFriendlyName(path), path}), (Object)toRepo);
    }

    private ImportException throwToRepoNotFound(Path path, String exportId) {
        throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.to.repository.missing", new Object[]{path, exportId}), null);
    }

    private void warnPathUnexpected(ImportContext context, Path path) {
        context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.path.invalid", new Object[]{this.getEntryFriendlyName(path), path}), null);
    }
}

