/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.pull.ActivityMetadataVisitor;
import com.atlassian.stash.internal.migration.entity.pull.BasePullRequestActivityMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@JsonIgnoreProperties(value={"action"}, ignoreUnknown=true)
public class PullRequestMergeActivityMetadata
extends BasePullRequestActivityMetadata {
    @JsonProperty
    private final boolean autoMerge;
    @JsonProperty
    private final String hash;

    @JsonCreator
    public PullRequestMergeActivityMetadata(@JsonProperty(value="createdTimestamp") long createdTimestamp, @JsonProperty(value="userId") @Nonnull String userId, @JsonProperty(value="autoMerge") boolean autoMerge, @JsonProperty(value="hash") String hash) {
        super(PullRequestAction.MERGED, createdTimestamp, userId);
        this.autoMerge = autoMerge;
        this.hash = hash;
    }

    public PullRequestMergeActivityMetadata(@Nonnull PullRequestMergeActivity activity, @Nonnull ExportContext exportContext) {
        super((PullRequestActivity)activity, exportContext);
        this.autoMerge = activity.isAutoMerge();
        this.hash = InternalConverter.convertToInternalPullRequestMergeActivity((PullRequestMergeActivity)activity).getHash();
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isAutoMerge() {
        return this.autoMerge;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"activity").addValue((Object)"merged").add("created", (Object)MigrationMetadata.formatTimestamp(this.getCreatedTimestamp())).add("userId", (Object)this.getUserId()).add("autoMerge", this.autoMerge).add("hash", (Object)this.hash).omitNullValues().toString();
    }

    @Override
    void accept(@Nonnull ActivityMetadataVisitor visitor) {
        Objects.requireNonNull(visitor, "visitor").visit(this);
    }
}

