/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.RepositoryRef;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestFromRefMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestParticipantMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestToRefMetadata;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PullRequestMetadata
implements MigrationMetadata {
    @JsonProperty
    private final Collection<PullRequestParticipantMetadata> allParticipants;
    @JsonProperty
    private final Long closedTimestamp;
    @JsonProperty
    private final long createdTimestamp;
    @JsonProperty
    private final String description;
    @JsonProperty
    private final boolean draft;
    @JsonProperty
    private final PullRequestFromRefMetadata fromRef;
    @JsonProperty
    private final long id;
    @JsonProperty
    private final long rescopedTimestamp;
    @JsonProperty
    private final PullRequestState state;
    @JsonProperty
    private final String title;
    @JsonProperty
    private final PullRequestToRefMetadata toRef;
    @JsonProperty
    private final long updatedTimestamp;
    @JsonProperty
    private final int version;

    @JsonCreator
    public PullRequestMetadata(@JsonProperty(value="allParticipants") @Nonnull Collection<PullRequestParticipantMetadata> allParticipants, @JsonProperty(value="closedTimestamp") Long closedTimestamp, @JsonProperty(value="createdTimestamp") @Nonnull Long createdTimestamp, @JsonProperty(value="description") String description, @JsonProperty(value="draft") boolean draft, @JsonProperty(value="fromRef") @Nonnull PullRequestFromRefMetadata fromRef, @JsonProperty(value="id") long id, @JsonProperty(value="rescopedTimestamp") @Nonnull Long rescopedTimestamp, @JsonProperty(value="state") @Nonnull PullRequestState state, @JsonProperty(value="title") @Nonnull String title, @JsonProperty(value="toRef") @Nonnull PullRequestToRefMetadata toRef, @JsonProperty(value="updatedTimestamp") @Nonnull Long updatedTimestamp, @JsonProperty(value="version") @Nonnull Integer version) {
        this.allParticipants = Objects.requireNonNull(allParticipants, "allParticipants");
        this.closedTimestamp = closedTimestamp;
        this.createdTimestamp = Objects.requireNonNull(createdTimestamp, "createdTimestamp");
        this.description = description;
        this.draft = draft;
        this.fromRef = Objects.requireNonNull(fromRef, "fromRef");
        this.id = id;
        this.rescopedTimestamp = rescopedTimestamp;
        this.state = Objects.requireNonNull(state, "state");
        this.title = Objects.requireNonNull(StringUtils.trimToNull((String)title), "title");
        this.toRef = Objects.requireNonNull(toRef, "toRef");
        this.updatedTimestamp = Objects.requireNonNull(updatedTimestamp, "updatedTimestamp");
        this.version = Objects.requireNonNull(version, "version");
    }

    public PullRequestMetadata(@Nonnull InternalPullRequest pr, @Nonnull ExportContext context) {
        this.allParticipants = PullRequestMetadata.getAllParticipantMetadata(context, pr);
        this.closedTimestamp = PullRequestMetadata.getTimestampOrNull(pr.getClosedDate());
        this.createdTimestamp = pr.getCreatedDate().getTime();
        this.description = pr.getDescription();
        this.draft = pr.isDraft();
        this.fromRef = new PullRequestFromRefMetadata(!pr.isCrossRepository(), (PullRequestRef)pr.getFromRef(), context);
        this.id = pr.getId();
        this.rescopedTimestamp = pr.getRescopedDate().getTime();
        this.toRef = new PullRequestToRefMetadata((RepositoryRef)pr.getToRef());
        this.state = pr.getState();
        this.title = pr.getTitle();
        this.updatedTimestamp = pr.getUpdatedDate().getTime();
        this.version = pr.getVersion();
    }

    @Nonnull
    public Collection<PullRequestParticipantMetadata> getAllParticipants() {
        return this.allParticipants;
    }

    @Nullable
    public Long getClosedTimestamp() {
        return this.closedTimestamp;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public PullRequestFromRefMetadata getFromRef() {
        return this.fromRef;
    }

    public long getId() {
        return this.id;
    }

    public long getRescopedTimestamp() {
        return this.rescopedTimestamp;
    }

    @Nonnull
    public PullRequestState getState() {
        return this.state;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public PullRequestToRefMetadata getToRef() {
        return this.toRef;
    }

    public long getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isCrossRepository() {
        return this.fromRef.getRepoId().isPresent();
    }

    public boolean isDraft() {
        return this.draft;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"pullrequest").addValue((Object)("#" + this.id)).addValue(this.draft).addValue((Object)this.state).addValue((Object)("@" + this.version)).addValue((Object)this.fromRef).addValue((Object)this.toRef).add("created", (Object)MigrationMetadata.formatTimestamp(this.createdTimestamp)).add("closed", (Object)MigrationMetadata.formatTimestamp(this.closedTimestamp)).add("rescoped", (Object)MigrationMetadata.formatTimestamp(this.rescopedTimestamp)).add("updated", (Object)MigrationMetadata.formatTimestamp(this.updatedTimestamp)).add("allParticipants.count", this.allParticipants.size()).omitNullValues().toString();
    }

    private static Collection<PullRequestParticipantMetadata> getAllParticipantMetadata(ExportContext context, InternalPullRequest pr) {
        return pr.getAllParticipants().stream().map(participant -> new PullRequestParticipantMetadata(context, (PullRequestParticipant)participant)).collect(Collectors.toList());
    }

    private static Long getTimestampOrNull(Date date) {
        return date == null ? null : Long.valueOf(date.getTime());
    }
}

