/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.migration.UserImportService;
import com.atlassian.stash.internal.migration.entity.MigrationEntityIdentifierMapper;
import com.atlassian.stash.internal.migration.entity.comment.AttachmentTransformer;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestFromRefMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestParticipantMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestToRefMetadata;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.PullRequestImportRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PullRequestMetadataImporter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(PullRequestMetadataImporter.class);
    private final AttachmentTransformer attachmentTransformer;
    private final I18nService i18nService;
    private final InternalPullRequestService pullRequestService;
    private final RepositoryService repositoryService;
    private final UserImportService userImportService;

    @Autowired
    public PullRequestMetadataImporter(AttachmentTransformer attachmentTransformer, InternalPullRequestService pullRequestService, RepositoryService repositoryService, I18nService i18nService, UserImportService userImportService) {
        this.attachmentTransformer = attachmentTransformer;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
        this.i18nService = i18nService;
        this.userImportService = userImportService;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void importPullRequest(@Nonnull ImportContext context, @Nonnull EntrySource entry, @Nonnull Repository repo, long scopedId) throws IOException {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(entry, "entry");
        Objects.requireNonNull(repo, "repo");
        log.debug("Importing pull request {}", (Object)MigrationEntityIdentifierMapper.getPullRequestIdentifier(repo, scopedId));
        entry.read(inputStream -> {
            PullRequestMetadata metadata = this.readMetadataOrFail(repo, scopedId, (InputStream)inputStream);
            this.ensureNotAlreadyExists(repo, scopedId);
            Repository fromRepo = this.resolveFromRepoOrFail(context, repo, scopedId, metadata);
            this.createPullRequest(context, fromRepo, metadata, repo, scopedId);
        });
    }

    private PullRequestImportRequest buildImportRequest(ImportContext context, Repository fromRepo, PullRequestMetadata metadata, Repository toRepo, long scopedId) {
        PullRequestFromRefMetadata fromRef = metadata.getFromRef();
        PullRequestToRefMetadata toRef = metadata.getToRef();
        PullRequestImportRequest.Builder importBuilder = ((PullRequestImportRequest.Builder)new PullRequestImportRequest.Builder().closedDate((Instant)Optional.ofNullable(metadata.getClosedTimestamp()).map(Instant::ofEpochMilli).orElse(null)).createdDate(Instant.ofEpochMilli(metadata.getCreatedTimestamp())).draft(metadata.isDraft()).from(fromRepo, fromRef.getId(), fromRef.getDisplayId(), fromRef.getLatestCommit()).rescopedDate(Instant.ofEpochMilli(metadata.getRescopedTimestamp())).scopedId(scopedId).state(metadata.getState()).title(metadata.getTitle())).to(toRepo, toRef.getId(), toRef.getDisplayId(), toRef.getLatestCommit()).updatedDate(Instant.ofEpochMilli(metadata.getUpdatedTimestamp())).version(metadata.getVersion());
        if (metadata.getDescription() != null) {
            importBuilder.description(this.attachmentTransformer.transformText(metadata.getDescription(), context));
        }
        for (PullRequestParticipantMetadata participant : metadata.getAllParticipants()) {
            String username = this.userImportService.findOrCreateUser(participant.getUserId(), context).getName();
            importBuilder.participant(username, participant.getRole(), participant.getStatus(), participant.getLastReviewedCommit());
        }
        return importBuilder.build();
    }

    private void createPullRequest(ImportContext context, Repository fromRepo, PullRequestMetadata metadata, Repository toRepo, long scopedId) {
        try {
            PullRequestImportRequest request = this.buildImportRequest(context, fromRepo, metadata, toRepo, scopedId);
            InternalPullRequest pr = InternalConverter.convertToInternalPullRequest((PullRequest)this.pullRequestService.importPullRequest(request));
            log.debug("Successfully imported pull request {}. Assigning it global ID {}", (Object)MigrationEntityIdentifierMapper.getPullRequestIdentifier(toRepo, scopedId), (Object)pr.getGlobalId());
        }
        catch (Exception e) {
            throw this.throwMetadataPersistFailed(toRepo, scopedId, e);
        }
    }

    private void ensureNotAlreadyExists(Repository toRepo, long scopedId) {
        if (this.pullRequestService.getById(toRepo.getId(), scopedId) != null) {
            throw this.throwConflict(toRepo, scopedId);
        }
    }

    private Optional<Repository> getRepository(ImportContext context, String exportId) {
        return context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(exportId).map(arg_0 -> ((RepositoryService)this.repositoryService).getById(arg_0));
    }

    private PullRequestMetadata readMetadataOrFail(Repository toRepo, long scopedId, InputStream inputStream) {
        try {
            return (PullRequestMetadata)OBJECT_MAPPER.readValue(inputStream, PullRequestMetadata.class);
        }
        catch (IOException e) {
            throw this.throwMetadataReadFailed(toRepo, scopedId, e);
        }
    }

    private Repository resolveFromRepoOrFail(ImportContext context, Repository toRepo, long scopedId, PullRequestMetadata metadata) {
        if (metadata.isCrossRepository()) {
            String fromRepoId = metadata.getFromRef().getRepoId().get();
            return this.getRepository(context, fromRepoId).orElseThrow(() -> this.throwFromRepoNotFound(toRepo, scopedId, fromRepoId));
        }
        return toRepo;
    }

    private ImportException throwConflict(Repository toRepo, long scopedId) {
        throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.conflict", new Object[]{MigrationEntityIdentifierMapper.getPullRequestIdentifier(toRepo, scopedId)}), (Object)toRepo);
    }

    private ImportException throwFromRepoNotFound(Repository toRepo, long scopedId, String fromRepoExportedId) {
        throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.from.repository.missing", new Object[]{MigrationEntityIdentifierMapper.getPullRequestIdentifier(toRepo, scopedId), fromRepoExportedId}), (Object)toRepo);
    }

    private ImportException throwMetadataPersistFailed(Repository toRepo, long scopedId, Exception e) {
        throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.metadata.persist.failed", new Object[]{MigrationEntityIdentifierMapper.getPullRequestIdentifier(toRepo, scopedId), e.getMessage()}), (Object)toRepo, (Throwable)e);
    }

    private ImportException throwMetadataReadFailed(Repository toRepo, long scopedId, Exception e) {
        throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.pullrequest.import.metadata.read.failed", new Object[]{MigrationEntityIdentifierMapper.getPullRequestIdentifier(toRepo, scopedId), e.getMessage()}), (Object)toRepo, (Throwable)e);
    }
}

