/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PullRequestParticipantMetadata
implements MigrationMetadata {
    @JsonProperty
    private final String lastReviewedCommit;
    @JsonProperty
    private final PullRequestRole role;
    @JsonProperty
    private final PullRequestParticipantStatus status;
    @JsonProperty
    private final String userId;

    @JsonCreator
    public PullRequestParticipantMetadata(@JsonProperty(value="lastReviewedCommit") String lastReviewedCommit, @JsonProperty(value="role") @Nonnull PullRequestRole role, @JsonProperty(value="status") @Nonnull PullRequestParticipantStatus status, @JsonProperty(value="userId") @Nonnull String userId) {
        this.lastReviewedCommit = lastReviewedCommit;
        this.role = Objects.requireNonNull(role, "role");
        this.status = Objects.requireNonNull(status, "status");
        this.userId = Objects.requireNonNull(StringUtils.trimToNull((String)userId), "userId");
    }

    public PullRequestParticipantMetadata(@Nonnull ExportContext exportContext, @Nonnull PullRequestParticipant participant) {
        this.lastReviewedCommit = participant.getLastReviewedCommit();
        this.role = participant.getRole();
        this.status = participant.getStatus();
        this.userId = exportContext.getEntityMapping(StandardMigrationEntityType.USER).getExportId((Object)participant.getUser().getId());
    }

    public String getLastReviewedCommit() {
        return this.lastReviewedCommit;
    }

    @Nonnull
    public PullRequestRole getRole() {
        return this.role;
    }

    @Nonnull
    public PullRequestParticipantStatus getStatus() {
        return this.status;
    }

    @Nonnull
    public String getUserId() {
        return this.userId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"participant").addValue((Object)this.role).add("userId", (Object)this.userId).add("status", (Object)this.status).add("lastReviewedCommit", (Object)this.lastReviewedCommit).omitNullValues().toString();
    }
}

