/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.pull.ActivityMetadataVisitor;
import com.atlassian.stash.internal.migration.entity.pull.BasePullRequestActivityMetadata;
import com.atlassian.stash.internal.migration.entity.pull.PullRequestRescopeCommitMetadata;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

@JsonIgnoreProperties(value={"action"}, ignoreUnknown=true)
public class PullRequestRescopeActivityMetadata
extends BasePullRequestActivityMetadata {
    @JsonProperty
    private final List<PullRequestRescopeCommitMetadata> commits;
    @JsonProperty
    private final String fromHash;
    @JsonProperty
    private final String previousFromHash;
    @JsonProperty
    private final String previousToHash;
    @JsonProperty
    private final String toHash;
    @JsonProperty
    private final Integer totalAdded;
    @JsonProperty
    private final Integer totalRemoved;

    @JsonCreator
    public PullRequestRescopeActivityMetadata(@JsonProperty(value="createdTimestamp") long createdTimestamp, @JsonProperty(value="userId") @Nonnull String userId, @JsonProperty(value="commits") @Nonnull List<PullRequestRescopeCommitMetadata> commits, @JsonProperty(value="fromHash") @Nonnull String fromHash, @JsonProperty(value="previousFromHash") @Nonnull String previousFromHash, @JsonProperty(value="previousToHash") @Nonnull String previousToHash, @JsonProperty(value="toHash") @Nonnull String toHash, @JsonProperty(value="totalAdded") Integer totalAdded, @JsonProperty(value="totalRemoved") Integer totalRemoved) {
        super(PullRequestAction.RESCOPED, createdTimestamp, userId);
        this.commits = Objects.requireNonNull(commits, "commits");
        this.fromHash = Objects.requireNonNull(fromHash, "fromHash");
        this.previousFromHash = Objects.requireNonNull(previousFromHash, "previousFromHash");
        this.previousToHash = Objects.requireNonNull(previousToHash, "previousToHash");
        this.toHash = Objects.requireNonNull(toHash, "toHash");
        this.totalAdded = totalAdded;
        this.totalRemoved = totalRemoved;
    }

    public PullRequestRescopeActivityMetadata(@Nonnull PullRequestRescopeActivity activity, @Nonnull ExportContext exportContext) {
        super((PullRequestActivity)activity, exportContext);
        InternalPullRequestRescopeActivity internalActivity = InternalConverter.convertToInternalPullRequestRescopeActivity((PullRequestRescopeActivity)activity);
        this.commits = (List)internalActivity.getCommits().stream().filter(Objects::nonNull).map(InternalPullRequestRescopeCommit.class::cast).map(commit -> new PullRequestRescopeCommitMetadata(commit.getAction(), commit.getCommitId())).collect(MoreCollectors.toImmutableList());
        this.fromHash = internalActivity.getFromHash();
        this.previousFromHash = internalActivity.getPreviousFromHash();
        this.previousToHash = internalActivity.getPreviousToHash();
        this.toHash = internalActivity.getToHash();
        if (internalActivity.isPrecalculated()) {
            this.totalAdded = internalActivity.getTotalAdded();
            this.totalRemoved = internalActivity.getTotalRemoved();
        } else {
            this.totalRemoved = null;
            this.totalAdded = null;
        }
    }

    @Nonnull
    public List<PullRequestRescopeCommitMetadata> getCommits() {
        return this.commits;
    }

    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    @Nonnull
    public String getPreviousFromHash() {
        return this.previousFromHash;
    }

    @Nonnull
    public String getPreviousToHash() {
        return this.previousToHash;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    @Nonnull
    public OptionalInt getTotalAdded() {
        return this.totalAdded == null ? OptionalInt.empty() : OptionalInt.of(this.totalAdded);
    }

    @Nonnull
    public OptionalInt getTotalRemoved() {
        return this.totalRemoved == null ? OptionalInt.empty() : OptionalInt.of(this.totalRemoved);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"activity").addValue((Object)"rescoped").add("created", (Object)MigrationMetadata.formatTimestamp(this.getCreatedTimestamp())).add("userId", (Object)this.getUserId()).add("fromHash", (Object)this.fromHash).add("toHash", (Object)this.toHash).add("previousFromHash", (Object)this.previousFromHash).add("previousToHash", (Object)this.previousToHash).add("commits.count", this.commits.size()).add("totalAdded", (Object)this.totalAdded).add("totalRemoved", (Object)this.totalRemoved).omitNullValues().toString();
    }

    @Override
    void accept(@Nonnull ActivityMetadataVisitor visitor) {
        Objects.requireNonNull(visitor, "visitor").visit(this);
    }
}

