/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.pull;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestReviewersUpdatedActivity;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.atlassian.stash.internal.migration.entity.pull.ActivityMetadataVisitor;
import com.atlassian.stash.internal.migration.entity.pull.BasePullRequestActivityMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(value={"action"}, ignoreUnknown=true)
public class PullRequestReviewersUpdatedActivityMetadata
extends BasePullRequestActivityMetadata {
    @JsonProperty
    private final List<String> addedIds;
    @JsonProperty
    private final List<String> removedIds;

    @JsonCreator
    public PullRequestReviewersUpdatedActivityMetadata(@JsonProperty(value="createdTimestamp") long createdTimestamp, @JsonProperty(value="userId") @Nonnull String userId, @JsonProperty(value="addedIds") @Nonnull List<String> addedIds, @JsonProperty(value="removedIds") @Nonnull List<String> removedIds) {
        super(PullRequestAction.UPDATED, createdTimestamp, userId);
        this.addedIds = Objects.requireNonNull(addedIds, "addedIds");
        this.removedIds = Objects.requireNonNull(removedIds, "removedIds");
    }

    public PullRequestReviewersUpdatedActivityMetadata(@Nonnull PullRequestReviewersUpdatedActivity activity, @Nonnull ExportContext exportContext) {
        super((PullRequestActivity)activity, exportContext);
        this.addedIds = (List)activity.getAddedReviewers().stream().map(reviewer -> PullRequestReviewersUpdatedActivityMetadata.toExportId(exportContext, reviewer)).collect(MoreCollectors.toImmutableList());
        this.removedIds = (List)activity.getRemovedReviewers().stream().map(reviewer -> PullRequestReviewersUpdatedActivityMetadata.toExportId(exportContext, reviewer)).collect(MoreCollectors.toImmutableList());
    }

    @Nonnull
    public List<String> getAddedIds() {
        return this.addedIds;
    }

    @Nonnull
    public List<String> getRemovedIds() {
        return this.removedIds;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"activity").addValue((Object)"reviewers:updated").add("created", (Object)MigrationMetadata.formatTimestamp(this.getCreatedTimestamp())).add("userId", (Object)this.getUserId()).add("addedIds.count", this.addedIds.size()).add("removedIds.count", this.removedIds.size()).toString();
    }

    @Override
    void accept(@Nonnull ActivityMetadataVisitor visitor) {
        visitor.visit(this);
    }
}

