/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.repository;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.EntityExportMapping;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.server.InternalStorageService;
import jakarta.annotation.Nonnull;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryAttachmentsExporter
implements Exporter {
    private static final Logger log = LoggerFactory.getLogger(RepositoryAttachmentsExporter.class);
    private final I18nService i18nService;
    private final InternalStorageService storageService;

    public RepositoryAttachmentsExporter(@Nonnull I18nService i18nService, @Nonnull InternalStorageService storageService) {
        this.i18nService = i18nService;
        this.storageService = storageService;
    }

    public void export(@Nonnull ExportContext exportContext, @Nonnull Repository repository) {
        try {
            Path attachmentsDir = this.storageService.getAttachmentsDir(repository);
            if (Files.isDirectory(attachmentsDir, new LinkOption[0])) {
                EntityExportMapping repoMappings = exportContext.getEntityMapping(StandardMigrationEntityType.REPOSITORY);
                Path repositoryPath = MigrationPaths.REPO_PATH_PREFIX.resolve(repoMappings.getExportId((Object)repository.getId()));
                Path attachmentsPath = repositoryPath.resolve(MigrationPaths.ATTACHMENTS_PATH);
                log.debug("Exporting attachments for {} from {} as archive entry with path {}", new Object[]{repository, attachmentsDir, attachmentsPath});
                exportContext.addEntriesAsArchive(attachmentsPath, archive -> archive.addPathFromDisk(attachmentsDir), true);
            }
        }
        catch (Exception e) {
            exportContext.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.attachments.export.failed", new Object[]{repository, e.getMessage()}), (Object)repository, (Throwable)e);
        }
    }
}

