/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.repository;

import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.stash.internal.attach.InternalAttachmentService;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.server.InternalStorageService;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryAttachmentsImporter
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(RepositoryAttachmentsImporter.class);
    private final InternalAttachmentService attachmentService;
    private final I18nService i18nService;
    private final RepositoryService repositoryService;
    private final InternalStorageService storageService;

    public RepositoryAttachmentsImporter(@Nonnull InternalAttachmentService attachmentService, @Nonnull I18nService i18nService, @Nonnull RepositoryService repositoryService, @Nonnull InternalStorageService storageService) {
        this.attachmentService = attachmentService;
        this.i18nService = i18nService;
        this.repositoryService = repositoryService;
        this.storageService = storageService;
    }

    public void onArchiveEntry(@Nonnull ImportContext importContext, @Nonnull ArchiveSource archiveSource) {
        Objects.requireNonNull(importContext, "importContext");
        Objects.requireNonNull(archiveSource, "archiveSource");
        Path archivePath = archiveSource.getPath();
        if (!archivePath.endsWith(MigrationPaths.ATTACHMENTS_PATH)) {
            importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.unknown.entry", new Object[]{archivePath}), null);
            return;
        }
        String exportId = archivePath.getParent().getFileName().toString();
        log.debug("Importing attachments from: {} with exportID: {}", (Object)archivePath, (Object)exportId);
        Repository repo = importContext.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(exportId).map(arg_0 -> ((RepositoryService)this.repositoryService).getById(arg_0)).orElse(null);
        if (repo == null) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.exportid.missing", new Object[]{exportId}), null);
        }
        Path target = this.storageService.getAttachmentsDir(repo);
        try {
            Files.createDirectories(target, new FileAttribute[0]);
            long fileCount = Files.walk(target, new FileVisitOption[0]).count();
            if (fileCount > 1L) {
                importContext.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.attachments.directory.notempty", new Object[]{target, fileCount - 1L}), (Object)repo);
            }
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.directory.creation.error", new Object[]{target}), (Object)repo, (Throwable)e);
        }
        try {
            archiveSource.read(entrySource -> {
                Path entryPath = entrySource.getPath();
                String filename = entryPath.getFileName().toString();
                Optional localId = importContext.getEntityMapping(StandardMigrationEntityType.ATTACHMENT).getLocalId(filename);
                if (localId.isPresent()) {
                    this.attachmentService.importAttachmentFile(repo, ((Long)localId.get()).longValue(), arg_0 -> ((EntrySource)entrySource).extractToDisk(arg_0));
                } else {
                    this.attachmentService.importAttachmentFile(repo, entryPath.toString(), arg_0 -> ((EntrySource)entrySource).extractToDisk(arg_0));
                }
            }, p -> true);
            log.debug("Imported attachments for repository: {} to: {}", (Object)repo, (Object)target);
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.attachments.import.failed", new Object[]{archivePath, target}), (Object)repo, (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            importContext.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.attachments.import.missing.database.entry", new Object[]{archivePath, target}), (Object)repo, (Throwable)e);
        }
    }
}

