/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.repository;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.EntityExportMapping;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.attach.InternalAttachmentService;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.server.InternalStorageService;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryAttachmentsMetadataExporter
implements Exporter {
    private static final Logger log = LoggerFactory.getLogger(RepositoryAttachmentsMetadataExporter.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final InternalAttachmentService attachmentService;
    private final I18nService i18nService;
    private final InternalStorageService storageService;

    public RepositoryAttachmentsMetadataExporter(@Nonnull InternalAttachmentService attachmentService, @Nonnull I18nService i18nService, @Nonnull InternalStorageService storageService) {
        this.attachmentService = attachmentService;
        this.i18nService = i18nService;
        this.storageService = storageService;
    }

    public void export(@Nonnull ExportContext exportContext, @Nonnull Repository repository) {
        try {
            Path attachmentsDir = this.storageService.getAttachmentsDir(repository);
            if (Files.isDirectory(attachmentsDir, new LinkOption[0])) {
                EntityExportMapping repoMappings = exportContext.getEntityMapping(StandardMigrationEntityType.REPOSITORY);
                Path repositoryPath = MigrationPaths.REPO_PATH_PREFIX.resolve(repoMappings.getExportId((Object)repository.getId()));
                Path attachmentsPath = repositoryPath.resolve(MigrationPaths.ATTACHMENTS_PATH);
                log.debug("Exporting attachments for {} from {} as archive entry with path {}", new Object[]{repository, attachmentsDir, attachmentsPath});
                exportContext.addEntry(repositoryPath.resolve(MigrationPaths.ATTACHMENT_DETAILS_PATH), outputStream -> {
                    try (JsonGenerator jsonGenerator = this.newJsonGenerator((OutputStream)outputStream);){
                        jsonGenerator.writeStartArray();
                        this.attachmentService.export(repository, (attachment, metadata) -> {
                            try {
                                jsonGenerator.writeStartObject();
                                jsonGenerator.writeNumberField("id", attachment.getId());
                                jsonGenerator.writeStringField("filename", attachment.getFilename());
                                if (metadata != null) {
                                    jsonGenerator.writeStringField("metadata", metadata.getMetadata());
                                }
                                jsonGenerator.writeEndObject();
                            }
                            catch (IOException e) {
                                exportContext.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.attachments.detail.export.failed", new Object[]{attachment.getId(), e.getMessage()}), (Object)repository, (Throwable)e);
                            }
                        });
                        jsonGenerator.writeEndArray();
                        jsonGenerator.flush();
                    }
                }, true);
            }
        }
        catch (Exception e) {
            exportContext.addError(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.attachments.export.failed", new Object[]{repository, e.getMessage()}), (Object)repository, (Throwable)e);
        }
    }

    private JsonGenerator newJsonGenerator(OutputStream outputStream) throws IOException {
        JsonGenerator generator = new JsonFactory().createJsonGenerator(outputStream);
        generator.setCodec((ObjectCodec)OBJECT_MAPPER);
        return generator;
    }
}

