/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.repository;

import com.atlassian.bitbucket.attachment.Attachment;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.stash.internal.attach.ImportAttachmentDetailsRequest;
import com.atlassian.stash.internal.attach.InternalAttachmentService;
import com.atlassian.stash.internal.migration.MigrationPaths;
import com.atlassian.stash.internal.migration.entity.repository.RepositoryAttachmentMetadata;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryAttachmentsMetadataImporter
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(RepositoryAttachmentsMetadataImporter.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final InternalAttachmentService attachmentService;
    private final I18nService i18nService;
    private final RepositoryService repositoryService;

    public RepositoryAttachmentsMetadataImporter(@Nonnull InternalAttachmentService attachmentService, @Nonnull I18nService i18nService, @Nonnull RepositoryService repositoryService) {
        this.attachmentService = attachmentService;
        this.i18nService = i18nService;
        this.repositoryService = repositoryService;
    }

    public void onEntry(@Nonnull ImportContext context, @Nonnull EntrySource entry) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(entry, "entry");
        Path path = entry.getPath();
        if (!path.endsWith(MigrationPaths.ATTACHMENT_DETAILS_PATH)) {
            context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.unknown.entry", new Object[]{path}), null);
            return;
        }
        String exportId = path.getParent().getFileName().toString();
        Repository repository = context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(exportId).map(arg_0 -> ((RepositoryService)this.repositoryService).getById(arg_0)).orElse(null);
        if (repository == null) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.import.exportid.missing", new Object[]{exportId}), null);
        }
        try {
            log.debug("Importing attachment details for repository: {}", (Object)repository);
            entry.read(inputStream -> {
                try (JsonParser jsonParser = OBJECT_MAPPER.getJsonFactory().createJsonParser(inputStream);){
                    if (jsonParser.nextToken() != JsonToken.START_ARRAY) {
                        throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.attachments.detail.import.invalid.data", new Object[]{repository}), null);
                    }
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        RepositoryAttachmentMetadata attachment = (RepositoryAttachmentMetadata)jsonParser.readValueAs(RepositoryAttachmentMetadata.class);
                        ImportAttachmentDetailsRequest attachmentDetails = new ImportAttachmentDetailsRequest(repository, attachment.getId(), attachment.getFilename(), attachment.getMetadata());
                        Attachment created = this.attachmentService.importAttachmentDetails(attachmentDetails);
                        context.getEntityMapping(StandardMigrationEntityType.ATTACHMENT).add(Long.toString(attachment.getId()), (Object)created.getId());
                    }
                }
                catch (Exception e) {
                    throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.attachments.detail.import.unexpectedly.failed", new Object[]{path, e.getMessage()}), null, (Throwable)e);
                }
            });
            log.debug("Imported attachment details for repository: {}", (Object)repository);
        }
        catch (Exception e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.repository.attachments.detail.import.unexpectedly.failed", new Object[]{path, e.getMessage()}), null, (Throwable)e);
        }
    }
}

