/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.entity.repository;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class RepositoryMetadata
implements MigrationMetadata {
    @JsonProperty
    private final boolean forkable;
    @JsonProperty
    private final String hierarchyId;
    @JsonProperty
    private final String id;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String originId;
    @JsonProperty
    private final String projectId;
    @JsonProperty(value="public")
    private final boolean publiclyAccessible;
    @JsonProperty
    private final String scmId;
    @JsonProperty
    private final String slug;

    @JsonCreator
    public RepositoryMetadata(@JsonProperty(value="forkable") boolean forkable, @JsonProperty(value="hierarchyId") String hierarchyId, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="originId") String originId, @JsonProperty(value="projectId") String projectId, @JsonProperty(value="public") boolean publiclyAccessible, @JsonProperty(value="scmId") String scmId, @JsonProperty(value="slug") String slug) {
        this.forkable = forkable;
        this.hierarchyId = hierarchyId;
        this.id = id;
        this.name = name;
        this.originId = originId;
        this.projectId = projectId;
        this.publiclyAccessible = publiclyAccessible;
        this.scmId = scmId;
        this.slug = slug;
    }

    public RepositoryMetadata(@Nonnull ExportContext context, @Nonnull Repository repository) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(repository, "repository");
        this.forkable = repository.isForkable();
        this.hierarchyId = repository.getHierarchyId();
        this.id = context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getExportId((Object)repository.getId());
        this.name = repository.getName();
        this.originId = Optional.ofNullable(repository.getOrigin()).map(origin -> context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getExportId((Object)origin.getId())).orElse(null);
        this.projectId = context.getEntityMapping(StandardMigrationEntityType.PROJECT).getExportId((Object)repository.getProject().getId());
        this.publiclyAccessible = repository.isPublic();
        this.scmId = repository.getScmId();
        this.slug = repository.getSlug();
    }

    @Nonnull
    public String getHierarchyId() {
        return this.hierarchyId;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Optional<String> getOriginId() {
        return Optional.ofNullable(this.originId);
    }

    @Nonnull
    public String getProjectId() {
        return this.projectId;
    }

    @Nonnull
    public String getScmId() {
        return this.scmId;
    }

    @Nonnull
    public String getSlug() {
        return this.slug;
    }

    public boolean isForkable() {
        return this.forkable;
    }

    public boolean isPublic() {
        return this.publiclyAccessible;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"repository").addValue((Object)this.id).addValue((Object)this.scmId).addValue((Object)this.slug).add("projectId", (Object)this.projectId).add("hierarchyId", (Object)this.hierarchyId).add("originId", (Object)this.originId).add("forkable", this.forkable).add("public", this.publiclyAccessible).toString();
    }
}

