/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.integrity;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.integrity.IntegrityCheckReporter;
import com.atlassian.stash.internal.integrity.IntegrityCheckService;
import com.atlassian.stash.internal.integrity.PullRequestIntegrityCheckRequest;
import com.atlassian.stash.internal.migration.integrity.ImportIntegrityCheckHelper;
import com.atlassian.stash.internal.migration.integrity.ImportIntegrityCheckRequest;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@DefaultApplicationMode
@Profiled
@Component(value="importIntegrityCheckHelper")
public class DefaultImportIntegrityCheckHelper
implements ImportIntegrityCheckHelper {
    private final IntegrityCheckReporter checkReporter;
    private final IntegrityCheckService checkService;
    private final I18nService i18nService;

    @Autowired
    public DefaultImportIntegrityCheckHelper(IntegrityCheckReporter checkReporter, IntegrityCheckService checkService, I18nService i18nService) {
        this.checkReporter = checkReporter;
        this.checkService = checkService;
        this.i18nService = i18nService;
    }

    @Override
    public void runPullRequestChecks(@Nonnull ImportIntegrityCheckRequest request) {
        Objects.requireNonNull(request, "request");
        try {
            this.checkReporter.startedForImport();
            PullRequestIntegrityCheckRequest pullRequestCheckRequest = new PullRequestIntegrityCheckRequest.Builder().hierarchyId(request.getHierarchyId()).build();
            this.runAndReport(() -> this.checkService.checkMergedPullRequests(pullRequestCheckRequest).forEach(mergeActivity -> request.getContext().addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.inconsistent.merged.pullrequest", new Object[]{mergeActivity.getToRef().getRepository().getId(), mergeActivity.getPullRequestId()}), mergeActivity)), request);
            this.runAndReport(() -> this.checkService.scheduleOpenPullRequestChecksByRescope(pullRequestCheckRequest), request);
        }
        finally {
            this.checkReporter.complete();
        }
    }

    @Override
    public void runRepositoryChecks(@Nonnull ImportIntegrityCheckRequest request) {
        Objects.requireNonNull(request, "request");
        try {
            this.checkReporter.startedForImport();
            this.runAndReport(() -> this.checkService.checkRepositories(request.getHierarchyId()).forEach((repository, inconsistencies) -> inconsistencies.forEach(inconsistency -> request.getContext().addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.inconsistent.repository", new Object[]{inconsistency}), repository, null))), request);
        }
        finally {
            this.checkReporter.complete();
        }
    }

    private void runAndReport(Runnable runnable, ImportIntegrityCheckRequest request) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.migration.import.integrity.check.error", new Object[0]);
            this.checkReporter.error(message.getRootMessage(), new Object[]{e});
            request.getContext().addError(message, null, (Throwable)e);
        }
    }
}

