/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.permission;

import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;

public class AllProjectPermissionMetadata
implements MigrationMetadata {
    @JsonProperty
    private final boolean projectAdmin;
    @JsonProperty
    private final boolean projectRead;
    @JsonProperty
    private final boolean projectWrite;

    @JsonCreator
    public AllProjectPermissionMetadata(@JsonProperty(value="projectAdmin") boolean projectAdmin, @JsonProperty(value="projectRead") boolean projectRead, @JsonProperty(value="projectWrite") boolean projectWrite) {
        this.projectAdmin = projectAdmin;
        this.projectRead = projectRead;
        this.projectWrite = projectWrite;
    }

    private AllProjectPermissionMetadata(Builder builder) {
        this.projectAdmin = builder.projectAdmin;
        this.projectRead = builder.projectRead;
        this.projectWrite = builder.projectWrite;
    }

    public boolean isProjectAdmin() {
        return this.projectAdmin;
    }

    public boolean isProjectRead() {
        return this.projectRead;
    }

    public boolean isProjectWrite() {
        return this.projectWrite;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectAdmin", this.projectAdmin).add("projectRead", this.projectRead).add("projectWrite", this.projectWrite).toString();
    }

    public static class Builder {
        private boolean projectAdmin;
        private boolean projectRead;
        private boolean projectWrite;

        @Nonnull
        AllProjectPermissionMetadata build() {
            return new AllProjectPermissionMetadata(this);
        }

        @Nonnull
        Builder projectAdmin(boolean value) {
            this.projectAdmin = value;
            return this;
        }

        @Nonnull
        Builder projectRead(boolean value) {
            this.projectRead = value;
            return this;
        }

        @Nonnull
        Builder projectWrite(boolean value) {
            this.projectWrite = value;
            return this;
        }
    }
}

