/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.permission;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.PermittedGroup;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.migration.permission.AllProjectPermissionMetadata;
import com.atlassian.stash.internal.migration.permission.PermissionGrantMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PermissionExporter
implements Exporter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final PermissionAdminService permissionAdminService;

    public PermissionExporter(PermissionAdminService permissionAdminService) {
        this.permissionAdminService = permissionAdminService;
    }

    public void export(@Nonnull ExportContext context, @Nonnull Project project) {
        if (project.getType() != ProjectType.PERSONAL) {
            String projectId = context.getEntityMapping(StandardMigrationEntityType.PROJECT).getExportId((Object)project.getId());
            AllProjectPermissionMetadata allProjectPermissionMetadata = this.toAllProjectPermissionMetadata(project);
            Set<PermissionGrantMetadata> permissionGrants = PermissionExporter.toPermissionGrantMetadata(context, pageRequest -> this.permissionAdminService.findGroupsWithProjectPermission(project, null, pageRequest), pageRequest -> this.permissionAdminService.findUsersWithProjectPermission(project, null, pageRequest));
            this.writeJson(context, Paths.get("project", projectId, "all-permissions.json"), allProjectPermissionMetadata);
            this.writeJson(context, Paths.get("project", projectId, "permissions.json"), permissionGrants);
        }
    }

    public void export(@Nonnull ExportContext context, @Nonnull Repository repository) {
        String repositoryId = context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getExportId((Object)repository.getId());
        Set<PermissionGrantMetadata> permissionGrants = PermissionExporter.toPermissionGrantMetadata(context, pageRequest -> this.permissionAdminService.findGroupsWithRepositoryPermission(repository, null, pageRequest), pageRequest -> this.permissionAdminService.findUsersWithRepositoryPermission(repository, null, pageRequest));
        this.writeJson(context, Paths.get("repository", repositoryId, "permissions.json"), permissionGrants);
    }

    private static Set<PermissionGrantMetadata> toPermissionGrantMetadata(ExportContext context, Function<PageRequest, Page<PermittedGroup>> groups, Function<PageRequest, Page<PermittedUser>> users) {
        Map<Permission, List<PermittedGroup>> groupsByPermission = PageUtils.toStream(groups::apply, (int)100).collect(Collectors.groupingBy(PermittedGroup::getPermission));
        Map<Permission, List<PermittedUser>> usersByPermission = PageUtils.toStream(users::apply, (int)100).collect(Collectors.groupingBy(PermittedUser::getPermission));
        HashSet<PermissionGrantMetadata> permissionGrants = new HashSet<PermissionGrantMetadata>();
        Sets.union(groupsByPermission.keySet(), usersByPermission.keySet()).forEach(permission -> permissionGrants.add(new PermissionGrantMetadata(context, (Permission)permission, groupsByPermission.getOrDefault(permission, Collections.emptyList()), usersByPermission.getOrDefault(permission, Collections.emptyList()))));
        return permissionGrants;
    }

    private AllProjectPermissionMetadata toAllProjectPermissionMetadata(Project project) {
        return new AllProjectPermissionMetadata.Builder().projectAdmin(this.permissionAdminService.hasAllProjectPermission(Permission.PROJECT_ADMIN, project)).projectRead(this.permissionAdminService.hasAllProjectPermission(Permission.PROJECT_READ, project)).projectWrite(this.permissionAdminService.hasAllProjectPermission(Permission.PROJECT_WRITE, project)).build();
    }

    private void writeJson(ExportContext context, Path entryName, Object value) {
        context.addEntry(entryName, outputStream -> OBJECT_MAPPER.writeValue(outputStream, value), true);
    }
}

