/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.permission;

import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermittedGroup;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.migration.MigrationMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PermissionGrantMetadata
implements MigrationMetadata {
    @JsonProperty
    private final Set<String> groups;
    @JsonProperty
    private final String permission;
    @JsonProperty
    private final Set<String> userIds;

    @JsonCreator
    public PermissionGrantMetadata(@JsonProperty(value="groups") Set<String> groups, @JsonProperty(value="permission") String permission, @JsonProperty(value="userIds") Set<String> userIds) {
        this.groups = groups;
        this.permission = permission;
        this.userIds = userIds;
    }

    public PermissionGrantMetadata(ExportContext context, Permission permission, List<PermittedGroup> groups, List<PermittedUser> users) {
        this.groups = (Set)groups.stream().map(PermittedGroup::getGroup).collect(MoreCollectors.toImmutableSet());
        this.permission = permission.name();
        this.userIds = (Set)users.stream().map(permittedUser -> context.getEntityMapping(StandardMigrationEntityType.USER).getExportId((Object)permittedUser.getUser().getId())).collect(MoreCollectors.toImmutableSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionGrantMetadata that = (PermissionGrantMetadata)o;
        return Objects.equals(this.groups, that.groups) && Objects.equals(this.permission, that.permission) && Objects.equals(this.userIds, that.userIds);
    }

    @Nonnull
    public Set<String> getGroups() {
        return this.groups;
    }

    @Nonnull
    public String getPermission() {
        return this.permission;
    }

    @Nonnull
    public Set<String> getUserIds() {
        return this.userIds;
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.permission, this.userIds);
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("permission", (Object)this.permission).add("groups", this.groups).add("userIds", this.userIds).toString();
    }
}

