/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration.permission;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.EntityImportMapping;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.migration.permission.AllProjectPermissionMetadata;
import com.atlassian.stash.internal.migration.permission.PermissionGrantMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionImporter
implements Importer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(PermissionImporter.class);
    private static final PathMatcher matchAllProjectPermission = FileSystems.getDefault().getPathMatcher("glob:project/*/all-permissions.json");
    private static final PathMatcher matchProject = FileSystems.getDefault().getPathMatcher("glob:project/*/permissions.json");
    private static final PathMatcher matchRepository = FileSystems.getDefault().getPathMatcher("glob:repository/*/permissions.json");
    private final I18nService i18nService;
    private final PermissionAdminService permissionAdminService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;
    private final UserService userService;

    public PermissionImporter(I18nService i18nService, PermissionAdminService permissionAdminService, ProjectService projectService, RepositoryService repositoryService, UserService userService) {
        this.i18nService = i18nService;
        this.permissionAdminService = permissionAdminService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.userService = userService;
    }

    public void onArchiveEntry(@Nonnull ImportContext context, @Nonnull ArchiveSource archive) {
        throw new UnsupportedOperationException("PermissionImporter does not support importing archives");
    }

    public void onEntry(@Nonnull ImportContext context, @Nonnull EntrySource entry) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(entry, "entry");
        Path path = entry.getPath();
        log.debug("Importing permissions from path: {}", (Object)path);
        if (matchAllProjectPermission.matches(path)) {
            this.onAllProjectPermission(context, entry);
        } else if (matchProject.matches(path)) {
            this.onProject(context, entry);
        } else if (matchRepository.matches(path)) {
            this.onRepository(context, entry);
        } else {
            context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.import.unknown.entry", new Object[]{path}), null);
        }
    }

    private static String resolveExportId(EntrySource entry) {
        return entry.getPath().getName(1).toString();
    }

    private static AllProjectPermissionMetadata toAllProjectPermissionMetadata(InputStream inputStream) throws IOException {
        return (AllProjectPermissionMetadata)OBJECT_MAPPER.readValue(inputStream, AllProjectPermissionMetadata.class);
    }

    private static Stream<PermissionGrantMetadata> toPermissionGrantMetadata(InputStream inputStream) throws IOException {
        return Arrays.stream((PermissionGrantMetadata[])OBJECT_MAPPER.readValue(inputStream, PermissionGrantMetadata[].class));
    }

    private void onAllProjectPermission(ImportContext context, EntrySource entry) {
        Path path = entry.getPath();
        try {
            entry.read(inputStream -> {
                String exportId = PermissionImporter.resolveExportId(entry);
                Project project = this.resolveProjectOrFail(context, exportId);
                if (project.getType() == ProjectType.PERSONAL) {
                    context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.permission.project.all.import.personal", new Object[]{path}), null);
                    return;
                }
                AllProjectPermissionMetadata allProjectPermissionMetadata = PermissionImporter.toAllProjectPermissionMetadata(inputStream);
                this.setAllProjectPermission(project, Permission.PROJECT_ADMIN, allProjectPermissionMetadata.isProjectAdmin());
                this.setAllProjectPermission(project, Permission.PROJECT_READ, allProjectPermissionMetadata.isProjectRead());
                this.setAllProjectPermission(project, Permission.PROJECT_WRITE, allProjectPermissionMetadata.isProjectWrite());
                log.debug("Imported all project permission from path: {} externalId: {} internalId: {}", new Object[]{path, exportId, project.getId()});
            });
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.permission.project.all.import.failed", new Object[]{path}), (Throwable)e);
        }
    }

    private void onProject(ImportContext context, EntrySource entry) {
        Path path = entry.getPath();
        try {
            entry.read(inputStream -> {
                String exportId = PermissionImporter.resolveExportId(entry);
                Project project = this.resolveProjectOrFail(context, exportId);
                if (project.getType() == ProjectType.PERSONAL) {
                    context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.permission.project.import.personal", new Object[]{path}), null);
                    return;
                }
                PermissionImporter.toPermissionGrantMetadata(inputStream).forEach(permissionGrantMetadata -> {
                    Set<String> groups = this.resolveGroups(permissionGrantMetadata.getGroups(), context, path);
                    Set<ApplicationUser> users = this.resolveUsers(context, permissionGrantMetadata.getUserIds());
                    if (groups.isEmpty() && users.isEmpty()) {
                        context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.permission.import.empty.permission.request", new Object[]{path}), null);
                    } else {
                        Permission permission = Permission.valueOf((String)permissionGrantMetadata.getPermission());
                        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().projectPermission(permission, project).groups(groups).users(users).build());
                    }
                });
                log.debug("Imported project permissions from path: {} externalId: {} internalId: {}", new Object[]{path, exportId, project.getId()});
            });
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.permission.project.import.failed", new Object[]{path}), (Throwable)e);
        }
    }

    private void onRepository(ImportContext context, EntrySource entry) {
        Path path = entry.getPath();
        try {
            entry.read(inputStream -> {
                String exportId = PermissionImporter.resolveExportId(entry);
                Repository repository = this.resolveRepositoryOrFail(context, exportId);
                PermissionImporter.toPermissionGrantMetadata(inputStream).forEach(permissionGrantMetadata -> {
                    Set<String> groups = this.resolveGroups(permissionGrantMetadata.getGroups(), context, path);
                    Set<ApplicationUser> users = this.resolveUsers(context, permissionGrantMetadata.getUserIds());
                    if (groups.isEmpty() && users.isEmpty()) {
                        context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.permission.import.empty.permission.request", new Object[]{path}), null);
                    } else {
                        Permission permission = Permission.valueOf((String)permissionGrantMetadata.getPermission());
                        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().repositoryPermission(permission, repository).groups(groups).users(users).build());
                    }
                });
                log.debug("Imported repository permissions from path: {} externalId: {} internalId: {}", new Object[]{path, exportId, repository.getId()});
            });
        }
        catch (IOException e) {
            throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.permission.repository.import.failed", new Object[]{path}), (Throwable)e);
        }
    }

    private Set<String> resolveGroups(Set<String> groups, ImportContext context, Path path) {
        Map groupsByExistence = groups.stream().collect(Collectors.groupingBy(arg_0 -> ((UserService)this.userService).existsGroup(arg_0), Collectors.mapping(Function.identity(), MoreCollectors.toImmutableSet())));
        if (groupsByExistence.containsKey(false)) {
            context.addWarning(this.i18nService.createKeyedMessage("bitbucket.service.migration.permission.import.groups.skipped", new Object[]{groupsByExistence.get(false), path}), null);
        }
        return groupsByExistence.getOrDefault(true, Collections.emptySet());
    }

    private Set<ApplicationUser> resolveUsers(ImportContext context, Set<String> userIds) {
        return (Set)userIds.stream().map(arg_0 -> ((EntityImportMapping)context.getEntityMapping(StandardMigrationEntityType.USER)).getLocalId(arg_0)).filter(Optional::isPresent).map(Optional::get).map(id -> this.userService.getUserById(id.intValue(), true)).filter(Objects::nonNull).collect(MoreCollectors.toImmutableSet());
    }

    private Project resolveProjectOrFail(ImportContext context, String exportId) {
        return context.getEntityMapping(StandardMigrationEntityType.PROJECT).getLocalId(exportId).map(arg_0 -> ((ProjectService)this.projectService).getById(arg_0)).orElseThrow(() -> new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.permission.project.notfound", new Object[]{exportId})));
    }

    private Repository resolveRepositoryOrFail(ImportContext context, String exportId) {
        return context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(exportId).map(arg_0 -> ((RepositoryService)this.repositoryService).getById(arg_0)).orElseThrow(() -> new ImportException(this.i18nService.createKeyedMessage("bitbucket.service.migration.permission.repository.notfound", new Object[]{exportId})));
    }

    private void setAllProjectPermission(Project project, Permission permission, boolean permitted) {
        if (permitted) {
            this.permissionAdminService.grantAllProjectPermission(permission, project);
        } else {
            this.permissionAdminService.revokeAllProjectPermission(permission, project);
        }
    }
}

