/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mirror;

import com.atlassian.stash.internal.mirror.FarmCryptoService;
import com.atlassian.stash.internal.mode.MirrorApplicationMode;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.security.SecureRandom;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.stereotype.Component;

@Component(value="farmCryptoService")
@MirrorApplicationMode
public class DefaultFarmCryptoService
implements FarmCryptoService {
    private final int SALT_LENGTH_BYTES = 16;
    private String key;
    private SecureRandom randomGenerator;

    @Autowired
    public DefaultFarmCryptoService(@Value(value="${hazelcast.group.password}") String key) {
        Objects.requireNonNull(key, "key");
        this.randomGenerator = new SecureRandom();
        this.key = key;
    }

    @Override
    @Nonnull
    public byte[] decrypt(@Nonnull InputStream input) {
        Objects.requireNonNull(input, "input");
        try {
            byte[] salt = new byte[16];
            IOUtils.read((InputStream)input, (byte[])salt, (int)0, (int)16);
            byte[] cipherText = IOUtils.toByteArray((InputStream)input);
            return Encryptors.stronger((CharSequence)this.key, (CharSequence)new String(Hex.encode((byte[])salt))).decrypt(cipherText);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Bad payload. Please make sure that the payload was encrypted correctly", e);
        }
    }

    @Override
    @Nonnull
    public byte[] encrypt(@Nonnull InputStream input) {
        Objects.requireNonNull(input, "input");
        try {
            byte[] plaintext = IOUtils.toByteArray((InputStream)input);
            byte[] salt = new byte[16];
            this.randomGenerator.nextBytes(salt);
            byte[] cipherText = Encryptors.stronger((CharSequence)this.key, (CharSequence)new String(Hex.encode((byte[])salt))).encrypt(plaintext);
            byte[] payload = new byte[16 + cipherText.length];
            System.arraycopy(salt, 0, payload, 0, 16);
            System.arraycopy(cipherText, 0, payload, 16, cipherText.length);
            return payload;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

