/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mirror;

import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.backup.DatabaseTable;
import com.atlassian.stash.internal.mirror.MirrorActivityCleanupDao;
import com.atlassian.stash.internal.mode.MirrorApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.upgrade.UpgradeTask;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="mirrorRepositoryActivityCleanupTask")
@MirrorApplicationMode
@UpgradeTask(value="mirror-repo-activity-cleanup")
public class MirrorRepositoryActivityCleanupTask
implements ScheduledJobSource {
    public static final String KEY_TASK = "mirror-repo-activity-cleanup";
    static final JobId JOB_ID = JobId.of((String)MirrorRepositoryActivityCleanupTask.class.getSimpleName());
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)MirrorRepositoryActivityCleanupTask.class.getName());
    private static final Logger log = LoggerFactory.getLogger(MirrorRepositoryActivityCleanupTask.class);
    private final MirrorActivityCleanupDao cleanupDao;
    private final Duration initialScheduleDelay;
    private final Path markerFile;
    private final TransactionTemplate transactionTemplate;

    public MirrorRepositoryActivityCleanupTask(@DurationUnit(value=ChronoUnit.SECONDS) @Value(value="${mirror.repository.activity.cleanup.schedule.delay}") Duration scheduleDelay, HomeLayout homeLayout, MirrorActivityCleanupDao cleanupDao, PlatformTransactionManager transactionManager) {
        this.initialScheduleDelay = scheduleDelay;
        this.cleanupDao = cleanupDao;
        this.markerFile = homeLayout.getUpgradesDir().resolve(KEY_TASK);
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        if (Files.exists(this.markerFile, new LinkOption[0])) {
            log.debug("Skipping upgrade task to delete repository activities as they have already been deleted");
            return;
        }
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new RepositoryActivityDeletionJobRunner());
        Date startTime = Date.from(Instant.now().plus(this.initialScheduleDelay));
        schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce((Date)startTime)));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private void deleteRepositoryActivities() {
        log.info("Starting deletion of repository activities on mirror.");
        for (DatabaseTable table : Lists.reverse(MirrorActivityCleanupDao.CLEANABLE_TABLES.stream().toList())) {
            this.transactionTemplate.execute(status -> {
                this.cleanupDao.truncate(table);
                return null;
            });
            log.info("Successfully truncated table {}", (Object)table.getTableName());
        }
        MoreFiles.mkdir((Path)this.markerFile.getParent());
        try {
            MoreFiles.touch((Path)this.markerFile);
        }
        catch (IOException e) {
            log.error("Failed to create marker file {}", (Object)KEY_TASK);
        }
    }

    private class RepositoryActivityDeletionJobRunner
    implements JobRunner {
        private RepositoryActivityDeletionJobRunner() {
        }

        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            Objects.requireNonNull(request, "request");
            try {
                if (Files.exists(MirrorRepositoryActivityCleanupTask.this.markerFile, new LinkOption[0])) {
                    log.debug("Skipping upgrade task to delete repository activities as this has already been deleted");
                } else {
                    this.doRunJob();
                }
                return JobRunnerResponse.success();
            }
            catch (RuntimeException e) {
                log.error(e.toString());
                return JobRunnerResponse.failed((Throwable)e);
            }
        }

        private void doRunJob() {
            MirrorRepositoryActivityCleanupTask.this.deleteRepositoryActivities();
        }
    }
}

