/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mirror.hash;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashScheduler;
import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashService;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashType;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.mirror.hash.UpdateMirrorHashTask;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=DmzMirrorHashScheduler.class)
@Component(value="mirrorHashScheduler")
@DefaultApplicationMode
public class BucketedMirrorHashScheduler
implements DmzMirrorHashScheduler,
BucketProcessor<UpdateMirrorHashTask>,
EnvironmentAware {
    static final Function<UpdateMirrorHashTask, String> TO_BUCKET_ID = task -> Integer.toString(task.getRepositoryId());
    private static final Logger log = LoggerFactory.getLogger(BucketedMirrorHashScheduler.class);
    private final ConcurrencyService concurrencyService;
    private final DmzMirrorHashService hashService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private BucketedExecutor<UpdateMirrorHashTask> contentExecutor;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @Value(value="${plugin.mirroring.hash.retry.delay.offline}")
    private Duration delayOffline;
    private Environment environment;
    private BucketedExecutor<UpdateMirrorHashTask> metadataExecutor;

    @Autowired
    public BucketedMirrorHashScheduler(ConcurrencyService concurrencyService, DmzMirrorHashService hashService, RepositoryService repositoryService, SecurityService securityService) {
        this.concurrencyService = concurrencyService;
        this.hashService = hashService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
    }

    @PostConstruct
    public void initialize() {
        this.contentExecutor = this.createExecutor("content", 4);
        this.metadataExecutor = this.createExecutor("metadata", 6);
    }

    public void process(@Nonnull String bucketId, @Nonnull List<UpdateMirrorHashTask> tasks) {
        if (tasks.isEmpty()) {
            log.debug("{}: Nothing to do", (Object)bucketId);
            return;
        }
        UpdateMirrorHashTask task = tasks.get(0);
        MirrorHashType hashType = task.getType();
        this.securityService.withPermission(Permission.REPO_READ, "Updating " + String.valueOf(hashType) + " hash").call(() -> {
            int repositoryId = task.getRepositoryId();
            Repository repository = this.repositoryService.getById(repositoryId);
            if (repository == null) {
                log.info("{}: The repository has been deleted", (Object)repositoryId);
            } else if (repository.getState() == Repository.State.OFFLINE) {
                log.debug("{}: The repository is offline - retrying in {}", (Object)repository, (Object)this.delayOffline);
                this.schedule(task.getRepositoryId(), task.getType(), this.delayOffline);
            } else {
                log.debug("{}: Updating {} hash", (Object)repository, (Object)hashType);
                if (hashType == MirrorHashType.CONTENT) {
                    this.hashService.updateContentHash(repository);
                } else {
                    this.hashService.updateMetadataHash(repository);
                }
            }
            return null;
        });
    }

    public void schedule(@Nonnull Repository repository, @Nonnull MirrorHashType hashType, @Nonnull Duration delay) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(hashType, "hashType");
        Objects.requireNonNull(delay, "delay");
        this.schedule(repository.getId(), hashType, delay);
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    @PreDestroy
    public void shutdown() {
        try {
            BucketedExecutor<UpdateMirrorHashTask> contentExecutor = this.contentExecutor;
            if (contentExecutor != null) {
                contentExecutor.shutdown();
                this.contentExecutor = null;
            }
        }
        finally {
            BucketedExecutor<UpdateMirrorHashTask> metadataExecutor = this.metadataExecutor;
            if (metadataExecutor != null) {
                metadataExecutor.shutdown();
                this.metadataExecutor = null;
            }
        }
    }

    @VisibleForTesting
    void setDelayOffline(Duration delayOffline) {
        this.delayOffline = delayOffline;
    }

    private BucketedExecutor<UpdateMirrorHashTask> createExecutor(String type, int defaultThreads) {
        int threads = (Integer)this.environment.getProperty("plugin.mirroring.hash." + type + ".threads", Integer.class, (Object)defaultThreads);
        return this.concurrencyService.getBucketedExecutor("mirror-hash:" + type, new BucketedExecutorSettings.Builder(TO_BUCKET_ID, (BucketProcessor)this).batchSize(Integer.MAX_VALUE).maxAttempts(2).maxConcurrency(threads, ConcurrencyPolicy.PER_NODE).build());
    }

    private void schedule(int repositoryId, MirrorHashType hashType, Duration delay) {
        (hashType == MirrorHashType.CONTENT ? this.contentExecutor : this.metadataExecutor).schedule((Serializable)new UpdateMirrorHashTask(repositoryId, hashType), delay.getSeconds(), TimeUnit.SECONDS);
    }
}

