/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mirror.hash;

import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashService;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHash;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashCallback;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashType;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashes;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashesCallback;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.mirror.hash.MirrorHashDao;
import com.atlassian.stash.internal.mirror.hash.RepositoryHasher;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=DmzMirrorHashService.class)
@DependsOn(value={"migrateMirrorHashUpgradeTask"})
@Service(value="mirrorHashService")
@Transactional(readOnly=true)
public class DefaultMirrorHashService
implements DmzMirrorHashService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMirrorHashService.class);
    private final MirrorHashDao hashDao;
    private final RepositoryHasher hasher;
    private final TransactionTemplate readWriteTransaction;

    @Autowired
    public DefaultMirrorHashService(MirrorHashDao hashDao, RepositoryHasher hasher, PlatformTransactionManager transactionManager) {
        this.hashDao = hashDao;
        this.hasher = hasher;
        this.readWriteTransaction = new TransactionTemplate(transactionManager);
    }

    @Nonnull
    public Map<Integer, MirrorHashes> mapHashesByRepositoryId(@Nonnull Set<Integer> repositoryIds) {
        if (Objects.requireNonNull(repositoryIds, "repositoryIds").isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap hashesById = new HashMap(repositoryIds.size(), 1.0f);
        for (List ids : Iterables.partition(repositoryIds, (int)100)) {
            Stream stream = this.hashDao.streamByRepositoryIds((Collection)ids);
            try {
                stream.forEach(hashes -> hashesById.put(hashes.getRepositoryId(), hashes));
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return Collections.unmodifiableMap(hashesById);
    }

    @Nonnull
    public Map<Integer, MirrorHash> mapHashesByRepositoryId(@Nonnull Set<Integer> repositoryIds, @Nonnull MirrorHashType type, @Nullable Date updatedSince) {
        Objects.requireNonNull(type, "type");
        if (Objects.requireNonNull(repositoryIds, "repositoryIds").isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap hashById = new HashMap(repositoryIds.size(), 1.0f);
        for (List ids : Iterables.partition(repositoryIds, (int)100)) {
            Stream stream = this.hashDao.streamByRepositoryIds((Collection)ids, type, updatedSince);
            try {
                stream.forEach(hashes -> hashById.put(hashes.getRepositoryId(), hashes));
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return Collections.unmodifiableMap(hashById);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void setContentHash(@Nonnull Repository repository, @Nonnull String hash) {
        this.storeHash(MirrorHashType.CONTENT, repository, hash);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void setMetadataHash(@Nonnull Repository repository, @Nonnull String hash) {
        this.storeHash(MirrorHashType.METADATA, repository, hash);
    }

    public void streamAll(@Nonnull MirrorHashesCallback callback) throws IOException {
        boolean callEnd = false;
        try (Stream stream = this.hashDao.streamRepositories();){
            MirrorHashes hashes;
            callback.onStart();
            callEnd = true;
            Iterator iterator = MoreStreams.asIterable((Stream)stream).iterator();
            while (iterator.hasNext() && callback.onHashes(hashes = (MirrorHashes)iterator.next())) {
            }
            callEnd = false;
            callback.onEnd();
        }
        catch (IOException | RuntimeException e) {
            if (callEnd) {
                try {
                    callback.onEnd();
                }
                catch (IOException | RuntimeException suppressed) {
                    e.addSuppressed(suppressed);
                }
            }
            throw e;
        }
    }

    public void stream(@Nonnull MirrorHashType type, Date updatedSince, @Nonnull MirrorHashCallback callback) throws IOException {
        boolean callEnd = false;
        try (Stream stream = this.hashDao.stream(type, updatedSince);){
            MirrorHash hash;
            callback.onStart();
            callEnd = true;
            Iterator iterator = MoreStreams.asIterable((Stream)stream).iterator();
            while (iterator.hasNext() && callback.onHash(hash = (MirrorHash)iterator.next())) {
            }
            callEnd = false;
            callback.onEnd();
        }
        catch (IOException | RuntimeException e) {
            if (callEnd) {
                try {
                    callback.onEnd();
                }
                catch (IOException | RuntimeException suppressed) {
                    e.addSuppressed(suppressed);
                }
            }
            throw e;
        }
    }

    @Nonnull
    @Transactional(propagation=Propagation.SUPPORTS)
    public Optional<String> updateContentHash(Repository repository) {
        return this.createAndStoreHash(MirrorHashType.CONTENT, repository);
    }

    @Nonnull
    @Transactional(propagation=Propagation.SUPPORTS)
    public Optional<String> updateMetadataHash(Repository repository) {
        return this.createAndStoreHash(MirrorHashType.METADATA, repository);
    }

    private Optional<String> createAndStoreHash(MirrorHashType type, Repository repository) {
        String hash = this.createHash(type, repository);
        this.storeHash(type, repository, hash);
        log.debug("{}: Generated new {} hash '{}'", new Object[]{repository, type, hash});
        return Optional.of(hash);
    }

    private String createHash(MirrorHashType type, Repository repository) {
        switch (type) {
            case CONTENT: {
                return this.hasher.hashContents(repository);
            }
            case METADATA: {
                return this.hasher.hashMetadata(repository);
            }
        }
        throw new UnsupportedOperationException(String.valueOf(type) + " hashes are not implemented");
    }

    private void storeHash(final MirrorHashType type, final Repository repository, final String hash) {
        this.readWriteTransaction.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(@Nonnull TransactionStatus status) {
                DefaultMirrorHashService.this.hashDao.set(type, repository.getId(), hash);
            }
        });
    }
}

