/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mirror.hash;

import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashScheduler;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashType;
import com.atlassian.bitbucket.event.project.ProjectModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDefaultBranchModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@DefaultApplicationMode
public class HashingRepositoryEventListener {
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final DmzMirrorHashScheduler scheduler;
    private Duration contentDelay;
    private Duration metadataDelay;

    @Autowired
    public HashingRepositoryEventListener(RepositoryService repositoryService, DmzMirrorHashScheduler scheduler, SecurityService securityService) {
        this.repositoryService = repositoryService;
        this.scheduler = scheduler;
        this.securityService = securityService;
        this.contentDelay = Duration.ofSeconds(30L);
        this.metadataDelay = Duration.ofSeconds(0L);
    }

    @EventListener
    public void onProjectModified(ProjectModifiedEvent event) {
        if (event.isKeyChanged()) {
            Project project = event.getNewValue();
            this.securityService.withPermission(Permission.PROJECT_READ, (Object)project, "Updating repo hashes").call(() -> {
                PageUtils.toStream(pageRequest -> this.repositoryService.findByProjectKey(project.getKey(), pageRequest), (int)500).forEach(this::scheduleMetadataUpdate);
                return null;
            });
        }
    }

    @EventListener
    public void onRepositoryCreated(RepositoryCreatedEvent event) {
        this.maybeScheduleMetadataUpdate(event.getRepository());
    }

    @EventListener
    public void onRepositoryDefaultBranchModified(RepositoryDefaultBranchModifiedEvent event) {
        this.maybeScheduleMetadataUpdate(event.getRepository());
    }

    @EventListener
    public void onRepositoryModified(RepositoryModifiedEvent event) {
        this.maybeScheduleMetadataUpdate(event.getNewValue());
    }

    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        this.scheduler.schedule(event.getRepository(), MirrorHashType.CONTENT, this.contentDelay);
    }

    @Value(value="${plugin.mirroring.hash.content.delay}")
    public void setContentDelay(long contentDelay) {
        this.contentDelay = Duration.ofSeconds(Math.max(contentDelay, 0L));
    }

    @Value(value="${plugin.mirroring.hash.metadata.delay}")
    public void setMetadataDelay(long metadataDelay) {
        this.metadataDelay = Duration.ofSeconds(Math.max(metadataDelay, 0L));
    }

    private void maybeScheduleMetadataUpdate(Repository repository) {
        this.scheduleMetadataUpdate(repository);
    }

    private void scheduleMetadataUpdate(Repository repository) {
        this.scheduler.schedule(repository, MirrorHashType.METADATA, this.metadataDelay);
    }
}

