/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mirror.hash;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.upgrade.UpgradeTask;
import jakarta.annotation.PostConstruct;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="migrateMirrorHashUpgradeTask")
@UpgradeTask(value="core-repo-hashes")
public class MigrateMirrorHashUpgradeTask {
    static final String KEY_TASK = "core-repo-hashes";
    static final String KEY_TASK_LOCK = "core-repo-hashes.lock";
    static final String PATH_HASH_DIR = "repo-hashes";
    private static final Logger log = LoggerFactory.getLogger(MigrateMirrorHashUpgradeTask.class);
    private final HomeLayout homeLayout;
    private final LockService lockService;

    @Autowired
    public MigrateMirrorHashUpgradeTask(HomeLayout homeLayout, LockService lockService) {
        this.homeLayout = homeLayout;
        this.lockService = lockService;
    }

    @PostConstruct
    public void apply() throws Exception {
        Path markerFile = this.homeLayout.getUpgradesDir().resolve(KEY_TASK);
        if (Files.exists(markerFile, new LinkOption[0])) {
            log.debug("Skipping upgrade task; it has already been completed");
            return;
        }
        try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(KEY_TASK_LOCK));){
            Path hashDir;
            if (Files.exists(markerFile, new LinkOption[0])) {
                log.debug("Skipping upgrade task; it was completed by another node");
            }
            if (Files.isDirectory(hashDir = this.homeLayout.getDataDir().resolve(PATH_HASH_DIR), new LinkOption[0])) {
                int deleted = this.deleteHashFiles(hashDir);
                if (deleted > 0) {
                    log.info("Successfully deleted {} repository hash files", (Object)deleted);
                }
            } else {
                log.debug("Skipping deletion of hashes directory as it does not exist");
            }
            MoreFiles.mkdir((Path)markerFile.getParent());
            MoreFiles.touch((Path)markerFile);
        }
    }

    private int deleteHashFiles(Path hashDir) throws IOException {
        int count = 0;
        try (Stream<Path> files2 = Files.list(hashDir);){
            for (Path file : MoreStreams.asIterable(files2)) {
                int repositoryId;
                if (!Files.isRegularFile(file, new LinkOption[0])) {
                    log.debug("Ignoring unexpected non-file: {}", (Object)file);
                    continue;
                }
                try {
                    repositoryId = Integer.parseInt(file.getFileName().toString());
                }
                catch (NumberFormatException e) {
                    log.debug("Ignoring unexpected non-hash file: {}", (Object)file);
                    continue;
                }
                try {
                    Files.delete(file);
                    ++count;
                }
                catch (IOException e) {
                    log.warn("The hash for repository {} could not be deleted", (Object)repositoryId, (Object)e);
                }
            }
        }
        catch (FileNotFoundException | NoSuchFileException files2) {
            // empty catch block
        }
        try {
            Files.delete(hashDir);
        }
        catch (DirectoryNotEmptyException e) {
            log.warn("{} could not be deleted; it should be removed manually", (Object)hashDir.toAbsolutePath());
        }
        catch (IOException e) {
            log.warn("{} could not be deleted", (Object)hashDir.toAbsolutePath(), (Object)e);
        }
        return count;
    }
}

