/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mirror.hash;

import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.RefsCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.stash.internal.mirror.hash.RepositoryHasher;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Duration;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="repositoryHasher")
public class ScmRepositoryHasher
implements RepositoryHasher {
    private static byte NULL = 0;
    private static final RefsCommandParameters REFS_PARAMETERS = new RefsCommandParameters.Builder().build();
    private static final Logger log = LoggerFactory.getLogger(ScmRepositoryHasher.class);
    private final ScmService scmService;
    private Duration timeout;

    @Autowired
    public ScmRepositoryHasher(ScmService scmService) {
        this.scmService = scmService;
        this.timeout = Duration.ofMinutes(2L);
    }

    @Override
    @Nonnull
    public String hashContents(@Nonnull Repository repository) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        Command command = this.scmService.getCommandFactory(repository).refs(REFS_PARAMETERS, ref -> {
            this.updateDigest(digest, ref.getId());
            digest.update(NULL);
            if (ref instanceof Tag) {
                Tag tag = (Tag)ref;
                this.updateDigest(digest, (String)MoreObjects.firstNonNull((Object)tag.getHash(), (Object)tag.getLatestCommit()));
            } else {
                this.updateDigest(digest, ref.getLatestCommit());
            }
            digest.update(NULL);
            return true;
        });
        command.setTimeout(this.timeout);
        command.call();
        return Hex.encodeHexString((byte[])digest.digest());
    }

    @Override
    @Nonnull
    public String hashMetadata(@Nonnull Repository repository) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        this.updateDigest(digest, repository.getName());
        digest.update(NULL);
        this.updateDigest(digest, repository.getDescription());
        digest.update(NULL);
        this.updateDigest(digest, repository.getProject().getKey());
        digest.update(NULL);
        digest.update((byte)(repository.isForkable() ? 1 : 0));
        digest.update(NULL);
        digest.update((byte)(repository.isPublic() ? 1 : 0));
        digest.update(NULL);
        Repository origin = repository.getOrigin();
        if (origin != null) {
            this.updateDigest(digest, origin.getProject().getKey());
            digest.update(NULL);
            this.updateDigest(digest, origin.getSlug());
            digest.update(NULL);
        }
        String branchId = this.getDefaultBranchId(repository);
        this.updateDigest(digest, branchId);
        return Hex.encodeHexString((byte[])digest.digest());
    }

    @Value(value="${plugin.mirroring.hash.content.timeout:${process.timeout.execution}}")
    public void setTimeout(long timeout) {
        this.timeout = Duration.ofSeconds(Math.max(timeout, 60L));
    }

    private String getDefaultBranchId(@Nonnull Repository repository) {
        try {
            Branch defaultBranch = (Branch)this.scmService.getCommandFactory(repository).defaultBranch().call();
            return defaultBranch == null ? null : defaultBranch.getId();
        }
        catch (NoDefaultBranchException e) {
            return e.getBranchName();
        }
        catch (Exception e) {
            log.warn("{}: The default branch could not be determined", (Object)repository, (Object)e);
            return null;
        }
    }

    private void updateDigest(MessageDigest digest, String value) {
        if (value != null) {
            digest.update(value.getBytes(StandardCharsets.UTF_8));
        }
    }
}

