/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification;

import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.stash.internal.notification.NotificationAddresser;
import com.atlassian.stash.internal.notification.NotificationManager;
import com.atlassian.stash.internal.plugin.NotificationHandlerModuleDescriptor;
import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultNotificationManager
implements NotificationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationManager.class);
    private final ExecutorService executorService;
    private final NotificationAddresser notificationAddresser;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;

    @Autowired
    public DefaultNotificationManager(ExecutorService executorService, NotificationAddresser notificationAddresser, PluginAccessor pluginAccessor, PluginController pluginController) {
        this.executorService = executorService;
        this.notificationAddresser = notificationAddresser;
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
    }

    @Override
    public void dispatch(@Nonnull Notification notification) {
        this.executorService.execute(() -> {
            try (Timer ignored = TimerUtils.start((String)("Dispatching notification: " + notification.getClass().getName()));){
                log.debug("Managing notification: {}", (Object)notification);
                Set<Watcher> watchers = this.notificationAddresser.getRecipients(notification);
                this.pluginAccessor.getEnabledModuleDescriptorsByClass(NotificationHandlerModuleDescriptor.class).stream().filter(descriptor -> descriptor.getNotificationClass().equals(notification.getClass().getCanonicalName())).forEach(descriptor -> {
                    try (Timer ignored2 = TimerUtils.start((String)("Dispatching notification to " + descriptor.getModuleClass().getName()));){
                        descriptor.getModule().handle(notification, watchers);
                    }
                    catch (ClassCastException e) {
                        String moduleKey = descriptor.getCompleteKey();
                        log.error("Failed to dispatch notification to handler {}. Disabling", (Object)moduleKey);
                        this.pluginController.disablePluginModule(moduleKey);
                    }
                });
            }
        });
    }
}

