/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification;

import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.dmz.notification.pull.AbstractPullRequestNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestActivityNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestDeletedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestMergedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestReviewedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestReviewerAddedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestReviewerRemovedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestReviewersUpdatedNotification;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.bitbucket.watcher.WatcherSearchRequest;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.notification.NotificationAddresser;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.SimpleWatcher;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WatcherNotificationAddresser
implements NotificationAddresser {
    private static final Logger log = LoggerFactory.getLogger(WatcherNotificationAddresser.class);
    private static final int MAX_PAGE_SIZE = 100;
    private final PermissionService permissionService;
    private final WatcherService watcherService;

    @Autowired
    public WatcherNotificationAddresser(PermissionService permissionService, WatcherService watcherService) {
        this.permissionService = permissionService;
        this.watcherService = watcherService;
    }

    @Override
    @Nonnull
    public Set<Watcher> getRecipients(@Nonnull Notification notification) {
        try (Timer ignored = TimerUtils.start((String)"Resolving recipients for a notification");){
            Set<Watcher> set = this.filterWatchers(this.maybeResolveWatchers(notification).orElseGet(() -> {
                final InternalWatchable watchable = InternalConverter.convertToInternalWatchable((Watchable)notification.getWatchable());
                if (watchable == null) {
                    return Stream.empty();
                }
                Stream watcherStream = PageUtils.toStream((PageProvider)new PageProvider<Watcher>(){

                    @Nonnull
                    public Page<Watcher> get(@Nonnull PageRequest pageRequest) {
                        return WatcherNotificationAddresser.this.watcherService.search(new WatcherSearchRequest.Builder((Watchable)watchable).transitive(true).build(), pageRequest);
                    }
                }, (int)100);
                return WatcherNotificationAddresser.handleNotificationsWithCustomWatchers(notification, watcherStream);
            }), notification);
            return set;
        }
    }

    private static boolean canNotifyInitiator(Notification notification) {
        PullRequestActivity activity;
        if (notification instanceof PullRequestMergedNotification) {
            return ((PullRequestMergedNotification)notification).isAutoMerge();
        }
        if (notification instanceof PullRequestActivityNotification && (activity = ((PullRequestActivityNotification)notification).getActivity()) instanceof PullRequestMergeActivity) {
            return ((PullRequestMergeActivity)activity).isAutoMerge();
        }
        return false;
    }

    private static Stream<Watcher> handleNotificationsWithCustomWatchers(Notification notification, Stream<Watcher> watcherStream) {
        if (notification instanceof PullRequestDeletedNotification) {
            PullRequestDeletedNotification deletedNotification = (PullRequestDeletedNotification)notification;
            watcherStream = Stream.concat(deletedNotification.getWatchers().stream(), watcherStream);
        }
        if (notification instanceof PullRequestReviewersUpdatedNotification || notification instanceof PullRequestReviewedNotification) {
            ApplicationUser author = ((AbstractPullRequestNotification)notification).getPullRequest().getAuthor().getUser();
            watcherStream = watcherStream.filter(watcher -> watcher.getUser().equals((Object)author));
        }
        return watcherStream;
    }

    private static boolean logIfFiltered(boolean value, ApplicationUser user, String reason) {
        if (!value) {
            log.debug("Notification not being sent to {}: {})", (Object)user, (Object)reason);
        }
        return value;
    }

    private static Collection<ApplicationUser> resolveParticipants(PullRequestNotification notification) {
        if (notification instanceof PullRequestReviewerAddedNotification) {
            return ((PullRequestReviewerAddedNotification)notification).getAddedReviewers();
        }
        if (notification instanceof PullRequestReviewerRemovedNotification) {
            return ((PullRequestReviewerRemovedNotification)notification).getRemovedReviewers();
        }
        return null;
    }

    private Set<Watcher> filterWatchers(Stream<Watcher> watchers, Notification notification) {
        ApplicationUser initiator = notification.getUser();
        return (Set)watchers.filter(watcher -> !watcher.getUser().equals((Object)initiator) || WatcherNotificationAddresser.canNotifyInitiator(notification)).filter(watcher -> {
            ApplicationUser user = watcher.getUser();
            return WatcherNotificationAddresser.logIfFiltered(StringUtils.isNotEmpty((CharSequence)user.getEmailAddress()), user, "User has no email address");
        }).filter(watcher -> {
            ApplicationUser user = watcher.getUser();
            return WatcherNotificationAddresser.logIfFiltered(this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER), user, "User is not licensed");
        }).filter(watcher -> {
            ApplicationUser user = watcher.getUser();
            InternalRepository repository = InternalConverter.convertToInternalWatchable((Watchable)watcher.getWatchable()).getScopeRepository();
            return WatcherNotificationAddresser.logIfFiltered(this.permissionService.hasRepositoryPermission(user, (Repository)repository, Permission.REPO_READ), user, "User does not have read access to [" + String.valueOf(repository) + "]");
        }).collect(MoreCollectors.toImmutableSet());
    }

    private Optional<Stream<Watcher>> maybeResolveWatchers(Notification notification) {
        PullRequestNotification prNotification;
        Collection<ApplicationUser> participants;
        if (notification instanceof PullRequestNotification && (participants = WatcherNotificationAddresser.resolveParticipants(prNotification = (PullRequestNotification)notification)) != null) {
            return Optional.of(this.toWatchers((Watchable)prNotification.getPullRequest(), participants));
        }
        return Optional.empty();
    }

    private Stream<Watcher> toWatchers(Watchable watchable, Collection<ApplicationUser> recipients) {
        return recipients.stream().map(user -> new SimpleWatcher(watchable, user, false));
    }
}

