/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.commit;

import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.dmz.notification.commit.CommitDiscussionCommentAddedNotification;
import com.atlassian.bitbucket.dmz.notification.commit.CommitDiscussionCommentRepliedNotification;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentAddedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentRepliedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.notification.NotificationManager;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommitDiscussionNotificationProducer {
    private final NotificationManager notificationManager;

    @Autowired
    public CommitDiscussionNotificationProducer(@Nonnull NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @EventListener
    public void onCommitDiscussionCommentAdded(CommitDiscussionCommentAddedEvent event) {
        this.notificationManager.dispatch((Notification)new CommitDiscussionCommentAddedNotification(event.getUser(), event.getDate(), event.getDiscussion(), event.getComment()));
    }

    @EventListener
    public void onCommitDiscussionCommentReplied(CommitDiscussionCommentRepliedEvent event) {
        this.notificationManager.dispatch((Notification)new CommitDiscussionCommentRepliedNotification(event.getUser(), event.getDate(), event.getDiscussion(), event.getComment(), event.getParent()));
    }
}

