/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.mention;

import com.atlassian.bitbucket.user.UserErasureRequest;
import com.atlassian.bitbucket.user.UserMentionScanner;
import com.atlassian.stash.internal.batch.BatchingStreamProcessor;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.LongStream;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

abstract class AbstractMentionUserErasureHandler<T> {
    private static final int FETCH_SIZE = 200;
    private static final Pattern FULL_MENTION_PATTERN = Pattern.compile("(?x)\n^ # From start of string\n@ # First character has to be @\n(?:\n    # Either match quoted username\n    \"\n    (\n        .*?[^\\\\] # Any characters allowed, ss long as the last character is not a backslash\n    )\n    \"\n    | # Or any word character\n    (\n        \\w+ # any word characters allowed\n    )\n)\n$");
    private static final int UPDATE_ATTEMPTS = 5;
    private final Function<List<Long>, List<? extends T>> batchLoader;
    private final Function<String, LongStream> idSearchFunction;
    private final UserMentionScanner mentionScanner;
    private final TransactionTemplate readOnlyTx;
    private final PlatformTransactionManager transactionManager;

    AbstractMentionUserErasureHandler(UserMentionScanner mentionScanner, PlatformTransactionManager transactionManager, Function<String, LongStream> idSearchFunction, Function<List<Long>, List<? extends T>> batchLoader) {
        this.batchLoader = batchLoader;
        this.idSearchFunction = idSearchFunction;
        this.mentionScanner = mentionScanner;
        this.transactionManager = transactionManager;
        this.readOnlyTx = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.readOnlyTx.setReadOnly(true);
    }

    public void eraseUser(@Nonnull UserErasureRequest request) {
        Objects.requireNonNull(request, "request");
        String originalUsername = request.getOriginalUsername();
        String originalEscapedUsername = FULL_MENTION_PATTERN.matcher(this.mentionScanner.renderMention(originalUsername)).replaceFirst("$1$2");
        String updatedUsername = request.getUpdatedUser().getName();
        String updatedRenderedMention = this.mentionScanner.renderMention(updatedUsername);
        this.handle(originalUsername, originalEscapedUsername, updatedRenderedMention);
    }

    protected void handle(final String originalUsername, String originalEscapedUsername, final String updatedRenderedMention) {
        LongStream ids = (LongStream)this.readOnlyTx.execute(status -> this.idSearchFunction.apply(originalEscapedUsername));
        new BatchingStreamProcessor<Long, LongStream, T>(this.transactionManager, 200, 5){

            @Override
            @Nonnull
            protected List<? extends T> loadBatch(@Nonnull List<Long> batch) {
                return AbstractMentionUserErasureHandler.this.batchLoader.apply(batch);
            }

            @Override
            protected void onEntity(@Nonnull T entity) {
                AbstractMentionUserErasureHandler.this.onEntity(entity, originalUsername, updatedRenderedMention);
            }
        }.process(ids);
    }

    abstract void onEntity(@Nonnull T var1, @Nonnull String var2, @Nonnull String var3);

    @Nonnull
    Optional<CharSequence> updateMentionsInText(@Nonnull String originalUsername, @Nonnull String text, @Nonnull String updatedRenderedMention) {
        return this.mentionScanner.replaceMentions((CharSequence)text, userMention -> {
            if (userMention.getUsername().equalsIgnoreCase(originalUsername)) {
                return Optional.of(updatedRenderedMention);
            }
            return Optional.empty();
        });
    }
}

