/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pullrequest;

import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.dmz.notification.pull.CommentAddedPullRequestNotification;
import com.atlassian.bitbucket.dmz.notification.pull.CommentRepliedPullRequestNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestActivityNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestApprovedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestAutoMergeCancelledNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestAutoMergeRequestedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestClosedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestDeletedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestFromRefRescopedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestMergedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestOpenedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestReopenedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestReviewedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestReviewerAddedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestReviewerRemovedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestReviewersUpdatedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestUnapprovedNotification;
import com.atlassian.bitbucket.dmz.notification.pull.PullRequestUpdatedNotification;
import com.atlassian.bitbucket.event.pull.PullRequestActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestAutoMergeCancelledEvent;
import com.atlassian.bitbucket.event.pull.PullRequestAutoMergeRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentAddedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentRepliedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantReviewedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantUnapprovedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReopenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.notification.NotificationManager;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestNotificationProducer {
    private final NotificationManager notificationManager;

    @Autowired
    public PullRequestNotificationProducer(@Nonnull NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @EventListener
    public void onActivityEvent(PullRequestActivityEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestActivityNotification(event.getActivity(), event.getDate(), event.getUser()));
    }

    @EventListener
    public void onPullRequestAutoMergeCancelled(PullRequestAutoMergeCancelledEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestAutoMergeCancelledNotification(event.getPullRequest(), event.getDate(), event.getReason(), event.getUser()));
    }

    @EventListener
    public void onPullRequestAutoMergeRequested(PullRequestAutoMergeRequestedEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestAutoMergeRequestedNotification(event.getPullRequest(), event.getDate(), event.getUser()));
    }

    @EventListener
    public void onPullRequestCommentAdded(PullRequestCommentAddedEvent event) {
        this.notificationManager.dispatch((Notification)new CommentAddedPullRequestNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getComment()));
    }

    @EventListener
    public void onPullRequestCommentReplied(PullRequestCommentRepliedEvent event) {
        this.notificationManager.dispatch((Notification)new CommentRepliedPullRequestNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getComment(), event.getParent()));
    }

    @EventListener
    public void onPullRequestUpdatedEvent(PullRequestUpdatedEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestUpdatedNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.isPreviousDraft(), event.getPreviousTitle(), event.getPreviousDescription(), event.getPreviousToBranch()));
    }

    @EventListener
    public void onPullRequestOpened(PullRequestOpenedEvent event) {
        this.dispatchReviewerAddedNotification((PullRequestEvent)event, (List)event.getPullRequest().getReviewers().stream().map(PullRequestParticipant::getUser).collect(MoreCollectors.toImmutableList()));
        this.notificationManager.dispatch((Notification)new PullRequestOpenedNotification(event.getPullRequest(), event.getDate(), event.getUser()));
    }

    @EventListener
    public void onPullRequestReviewersUpdated(PullRequestReviewersUpdatedEvent event) {
        this.dispatchReviewerAddedNotification((PullRequestEvent)event, Lists.newArrayList((Iterable)event.getAddedReviewers()));
        this.dispatchReviewerRemovedNotification((PullRequestEvent)event, Lists.newArrayList((Iterable)event.getRemovedReviewers()));
        this.dispatchReviewerUpdatedNotification(event);
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestMergedNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getCommit(), event.isAutoMerge()));
    }

    @EventListener
    public void onPullRequestClosed(PullRequestDeclinedEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestClosedNotification(event.getPullRequest(), event.getDate(), event.getUser()));
    }

    @EventListener
    public void onPullRequestDeleted(PullRequestDeletedEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        this.notificationManager.dispatch((Notification)new PullRequestDeletedNotification(pullRequest, event.getDate(), event.getUser(), event.getWatchers()));
    }

    @EventListener
    public void onPullRequestReopened(PullRequestReopenedEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestReopenedNotification(event.getPullRequest(), event.getDate(), event.getUser()));
    }

    @EventListener
    public void onPullRequestRescoped(PullRequestRescopedEvent event) {
        if (event.isFromHashUpdated()) {
            PullRequestFromRefRescopedNotification notification = new PullRequestFromRefRescopedNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getPreviousFromHash(), event.getPreviousToHash());
            this.notificationManager.dispatch((Notification)notification);
        }
    }

    @EventListener
    public void onPullRequestReviewed(PullRequestParticipantReviewedEvent event) {
        PullRequestApprovedNotification notification = event.getParticipant().isApproved() ? new PullRequestApprovedNotification(event.getPullRequest(), event.getDate(), event.getUser()) : new PullRequestReviewedNotification(event.getPullRequest(), event.getDate(), event.getUser());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onPullRequestUnapproved(PullRequestParticipantUnapprovedEvent event) {
        if (event.getPreviousStatus() != PullRequestParticipantStatus.NEEDS_WORK) {
            this.notificationManager.dispatch((Notification)new PullRequestUnapprovedNotification(event.getPullRequest(), event.getDate(), event.getUser()));
        }
    }

    private void dispatchReviewerAddedNotification(PullRequestEvent event, List<ApplicationUser> reviewers) {
        if (!reviewers.isEmpty()) {
            this.notificationManager.dispatch((Notification)new PullRequestReviewerAddedNotification(event.getPullRequest(), event.getDate(), event.getUser(), reviewers));
        }
    }

    private void dispatchReviewerRemovedNotification(PullRequestEvent event, List<ApplicationUser> reviewers) {
        if (!reviewers.isEmpty()) {
            this.notificationManager.dispatch((Notification)new PullRequestReviewerRemovedNotification(event.getPullRequest(), event.getDate(), event.getUser(), reviewers));
        }
    }

    private void dispatchReviewerUpdatedNotification(PullRequestReviewersUpdatedEvent event) {
        this.notificationManager.dispatch((Notification)new PullRequestReviewersUpdatedNotification(event.getPullRequest(), event.getDate(), event.getUser(), event.getAddedReviewers(), event.getRemovedReviewers()));
    }
}

