/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.core.NutclusterInstanceAware;
import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.internal.serialization.impl.ObjectDataInputStream;
import com.atlassian.nutcluster.internal.serialization.impl.ObjectDataOutputStream;
import com.atlassian.nutcluster.nio.MemberSocketInterceptor;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.stash.internal.cluster.ClusterJoinManager;
import com.atlassian.stash.internal.cluster.ClusterJoinMode;
import com.atlassian.stash.internal.cluster.ClusterJoinRequest;
import com.atlassian.stash.internal.cluster.ParanoidObjectDataInputStream;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class ClusterJoinSocketInterceptor
implements MemberSocketInterceptor,
NutclusterInstanceAware {
    private ClusterJoinManager clusterJoinManager;
    private NutclusterInstanceImpl nutcluster;

    public void init(Properties properties) {
        this.clusterJoinManager = (ClusterJoinManager)properties.get(ClusterJoinManager.class.getName());
    }

    public void onAccept(Socket socket) throws IOException {
        try (Timer ignored = TimerUtils.start((String)"nutcluster: intercept accept");){
            this.clusterJoinManager.accept(new SocketClusterJoinRequest(socket, this.nutcluster, ClusterJoinMode.ACCEPT));
        }
    }

    public void onConnect(Socket socket) throws IOException {
        try (Timer ignored = TimerUtils.start((String)"nutcluster: intercept connect");){
            this.clusterJoinManager.connect(new SocketClusterJoinRequest(socket, this.nutcluster, ClusterJoinMode.CONNECT));
        }
    }

    public void setNutclusterInstance(NutclusterInstance nutcluster) {
        this.nutcluster = (NutclusterInstanceImpl)nutcluster;
    }

    static class SocketClusterJoinRequest
    implements ClusterJoinRequest {
        private final NutclusterInstanceImpl nutcluster;
        private final ObjectDataInputStream in;
        private final ClusterJoinMode joinMode;
        private final String localAddress;
        private final int localPort;
        private final ObjectDataOutputStream out;
        private final String remoteAddress;
        private final int remotePort;

        SocketClusterJoinRequest(Socket socket, NutclusterInstanceImpl nutcluster, ClusterJoinMode joinMode) throws IOException {
            this.joinMode = joinMode;
            this.nutcluster = nutcluster;
            InternalSerializationService serializationService = nutcluster.getSerializationService();
            this.in = new ParanoidObjectDataInputStream(socket.getInputStream(), serializationService);
            this.out = new ObjectDataOutputStream(socket.getOutputStream(), serializationService);
            SocketAddress localSocket = socket.getLocalSocketAddress();
            if (socket.getLocalSocketAddress() instanceof InetSocketAddress) {
                InetSocketAddress localInetSocket = (InetSocketAddress)localSocket;
                this.localAddress = localInetSocket.getAddress().getHostAddress();
                this.localPort = localInetSocket.getPort();
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("Local socket address not an InetSocketAddress: {}", (Object)localSocket);
                this.localAddress = localSocket.toString();
                this.localPort = localSocket.hashCode();
            }
            SocketAddress remoteSocket = socket.getRemoteSocketAddress();
            if (socket.getRemoteSocketAddress() instanceof InetSocketAddress) {
                InetSocketAddress remoteInetSocket = (InetSocketAddress)remoteSocket;
                this.remoteAddress = remoteInetSocket.getAddress().getHostAddress();
                this.remotePort = remoteInetSocket.getPort();
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("Remote socket address not an InetSocketAddress: {}", (Object)remoteSocket);
                this.remoteAddress = remoteSocket.toString();
                this.remotePort = remoteSocket.hashCode();
            }
        }

        @Override
        @Nonnull
        public NutclusterInstance getNutcluster() {
            return this.nutcluster;
        }

        @Override
        @Nonnull
        public ClusterJoinMode getJoinMode() {
            return this.joinMode;
        }

        @Override
        @Nonnull
        public String getLocalAddress() {
            return this.localAddress;
        }

        @Override
        public int getLocalPort() {
            return this.localPort;
        }

        @Override
        @Nonnull
        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        @Override
        public int getRemotePort() {
            return this.remotePort;
        }

        @Override
        @Nonnull
        public ObjectDataInput in() {
            return this.in;
        }

        @Override
        @Nonnull
        public ObjectDataOutput out() {
            return this.out;
        }

        public String toString() {
            return String.valueOf((Object)this.joinMode) + "(" + this.localAddress + ":" + this.localPort + (this.joinMode == ClusterJoinMode.ACCEPT ? " <- " : " -> ") + this.remoteAddress + ":" + this.remotePort + ")";
        }
    }
}

