/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.dmz.cluster.ClusterNodeAttributes;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.nutcluster.core.MemberAttributeEvent;
import com.atlassian.nutcluster.core.MembershipEvent;
import com.atlassian.nutcluster.core.MembershipListener;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.cluster.NutclusterClusterNode;
import com.atlassian.stash.internal.mode.MirrorApplicationMode;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MirrorApplicationMode
@AvailableToPlugins(value=ClusterNodeAttributes.class)
public class DefaultClusterNodeAttributes
implements MembershipListener,
ClusterNodeAttributes {
    private final String listenerId;
    private final Map<String, Object> localAttributes;
    private final Map<String, Map<String, Object>> memberAttributes;
    private final NutclusterInstance nutcluster;
    private final Topic<AttributeSnapshotMessage> topicSnapshot;
    private final Topic<RequestAttributeSnapshotMessage> topicSnapshotRequest;
    private final Topic<AttributeUpdateMessage> topicUpdate;

    @Autowired
    public DefaultClusterNodeAttributes(NutclusterInstance nutcluster, TopicService topicService) {
        this.nutcluster = nutcluster;
        this.localAttributes = new ConcurrentHashMap<String, Object>();
        this.memberAttributes = new ConcurrentHashMap<String, Map<String, Object>>();
        this.topicUpdate = topicService.getTopic("mirror.node.attributes", new TopicSettings.Builder(AttributeUpdateMessage.class).dedupePendingMessages(true).build());
        this.topicSnapshot = topicService.getTopic("mirror.node.attributes.snapshot", new TopicSettings.Builder(AttributeSnapshotMessage.class).dedupePendingMessages(true).build());
        this.topicSnapshotRequest = topicService.getTopic("mirror.node.attributes.snapshot.request", new TopicSettings.Builder(RequestAttributeSnapshotMessage.class).dedupePendingMessages(true).build());
        this.topicUpdate.subscribe(this::onUpdateMessage);
        this.topicSnapshot.subscribe(this::onSnapshotMessage);
        this.topicSnapshotRequest.subscribe(this::onRequestSnapshotMessage);
        this.listenerId = nutcluster.getCluster().addMembershipListener((MembershipListener)this);
    }

    public String getAttribute(@Nonnull ClusterNode node, @Nonnull String attributeName) {
        return (String)this.internalGetAttribute(node, attributeName);
    }

    public Long getAttributeLong(@Nonnull ClusterNode node, @Nonnull String attributeName) {
        return (Long)this.internalGetAttribute(node, attributeName);
    }

    public void memberAdded(MembershipEvent membershipEvent) {
        this.topicSnapshot.publish((Serializable)new AttributeSnapshotMessage(this.localAttributes));
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    public void memberRemoved(MembershipEvent membershipEvent) {
        this.memberAttributes.remove(NutclusterClusterNode.transform(membershipEvent.getMember()).getVmId());
    }

    @PostConstruct
    public void onStart() {
        this.sync();
    }

    public void setAttribute(@Nonnull String attributeName, @Nonnull String value) {
        this.internalSetAttribute(attributeName, (Serializable)((Object)value));
    }

    public void setAttributeLong(@Nonnull String attributeName, @Nonnull Long value) {
        this.internalSetAttribute(attributeName, value);
    }

    public void sync() {
        this.topicSnapshotRequest.publish((Serializable)new RequestAttributeSnapshotMessage());
    }

    @PreDestroy
    public boolean unregister() {
        String id = this.listenerId;
        return id != null && this.nutcluster.getCluster().removeMembershipListener(id);
    }

    @Nullable
    private <T> T internalGetAttribute(@Nonnull ClusterNode node, @Nonnull String attributeName) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(attributeName, "attributeName");
        if (node.isLocal()) {
            Object value = this.localAttributes.get(attributeName);
            return (T)value;
        }
        Map<String, Object> attributes = this.memberAttributes.get(node.getVmId());
        if (attributes == null) {
            return null;
        }
        Object value = attributes.get(attributeName);
        return (T)value;
    }

    private void internalSetAttribute(@Nonnull String attributeName, @Nullable Serializable value) {
        Objects.requireNonNull(attributeName, "attributeName");
        this.localAttributes.compute(attributeName, (k, v) -> value);
        this.topicUpdate.publish(new AttributeUpdateMessage<Serializable>(attributeName, value));
    }

    private void onRequestSnapshotMessage(@Nonnull MessageEvent<RequestAttributeSnapshotMessage> message) {
        if (message.getSource().isLocal()) {
            return;
        }
        this.topicSnapshot.publish((Serializable)new AttributeSnapshotMessage(this.localAttributes));
    }

    private void onSnapshotMessage(@Nonnull MessageEvent<AttributeSnapshotMessage> message) {
        if (message.getSource().isLocal()) {
            return;
        }
        this.memberAttributes.computeIfAbsent(message.getSource().getVmId(), uuid -> new ConcurrentHashMap()).putAll(((AttributeSnapshotMessage)message.getMessage()).attributes);
    }

    private void onUpdateMessage(@Nonnull MessageEvent<AttributeUpdateMessage> message) {
        if (message.getSource().isLocal()) {
            return;
        }
        this.memberAttributes.computeIfAbsent(message.getSource().getVmId(), uuid -> new ConcurrentHashMap()).compute(((AttributeUpdateMessage)message.getMessage()).name, (k, v) -> ((AttributeUpdateMessage)message.getMessage()).value);
    }

    public static class AttributeUpdateMessage<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final T value;

        public AttributeUpdateMessage(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeUpdateMessage that = (AttributeUpdateMessage)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }
    }

    public static class AttributeSnapshotMessage
    implements Serializable {
        private final Map<String, Object> attributes;

        public AttributeSnapshotMessage(Map<String, Object> attributes) {
            this.attributes = ImmutableMap.copyOf(attributes);
        }
    }

    public static class RequestAttributeSnapshotMessage
    implements Serializable {
    }
}

