/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nutcluster;

import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.dmz.mirror.FarmQueueRequest;
import com.atlassian.bitbucket.dmz.mirror.ReadOnlyFarmQueueRequest;
import com.atlassian.nutcluster.serialization.OsgiSafe;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Stream;

public class DefaultFarmQueue<T extends Serializable>
implements FarmQueue<T> {
    private final BlockingQueue<OsgiSafe<FarmQueueRequest<T>>> blockingQueue;
    private final Class<T> queueClass;

    public DefaultFarmQueue(BlockingQueue<OsgiSafe<FarmQueueRequest<T>>> blockingQueue, Class<T> queueClass) {
        this.blockingQueue = blockingQueue;
        this.queueClass = queueClass;
    }

    public Class<T> getElementType() {
        return this.queueClass;
    }

    @VisibleForTesting
    public boolean isEmpty() {
        return this.blockingQueue.isEmpty();
    }

    public boolean offer(@Nonnull FarmQueueRequest<T> request) {
        Objects.requireNonNull(request, "request");
        return this.blockingQueue.offer(new OsgiSafe(request));
    }

    public int size() {
        return this.blockingQueue.size();
    }

    @Nonnull
    public Stream<ReadOnlyFarmQueueRequest<T>> streamItems() {
        return this.blockingQueue.stream().map(item -> new ReadOnlyFarmQueueRequest((FarmQueueRequest)item.getValue()));
    }

    @Nonnull
    public FarmQueueRequest<T> take() throws InterruptedException {
        return (FarmQueueRequest)this.blockingQueue.take().getValue();
    }
}

